/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.filter;

import io.deephaven.api.expression.Expression;
import io.deephaven.api.filter.FilterIn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FilterIn", generator="Immutables")
@Immutable
final class ImmutableFilterIn
extends FilterIn {
    private final Expression expression;
    private final List<Expression> values;

    private ImmutableFilterIn(Builder builder) {
        this.expression = builder.expression;
        this.values = ImmutableFilterIn.createUnmodifiableList(true, builder.values);
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public List<Expression> values() {
        return this.values;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFilterIn && this.equalTo(0, (ImmutableFilterIn)another);
    }

    private boolean equalTo(int synthetic, ImmutableFilterIn another) {
        return this.expression.equals(another.expression) && this.values.equals(another.values);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.expression.hashCode();
        h += (h << 5) + this.values.hashCode();
        return h;
    }

    public String toString() {
        return "FilterIn{expression=" + this.expression + ", values=" + this.values + "}";
    }

    private static ImmutableFilterIn validate(ImmutableFilterIn instance) {
        instance.checkNotEmpty();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="FilterIn", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements FilterIn.Builder {
        private static final long INIT_BIT_EXPRESSION = 1L;
        private long initBits = 1L;
        @Nullable
        private Expression expression;
        private final List<Expression> values = new ArrayList<Expression>();

        private Builder() {
        }

        @Override
        public final Builder expression(Expression expression) {
            Builder.checkNotIsSet(this.expressionIsSet(), "expression");
            this.expression = Objects.requireNonNull(expression, "expression");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder addValues(Expression element) {
            this.values.add(Objects.requireNonNull(element, "values element"));
            return this;
        }

        @Override
        public final Builder addValues(Expression ... elements) {
            for (Expression element : elements) {
                this.values.add(Objects.requireNonNull(element, "values element"));
            }
            return this;
        }

        @Override
        public final Builder addAllValues(Iterable<? extends Expression> elements) {
            for (Expression expression : elements) {
                this.values.add(Objects.requireNonNull(expression, "values element"));
            }
            return this;
        }

        @Override
        public ImmutableFilterIn build() {
            this.checkRequiredAttributes();
            return ImmutableFilterIn.validate(new ImmutableFilterIn(this));
        }

        private boolean expressionIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of FilterIn is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.expressionIsSet()) {
                attributes.add("expression");
            }
            return "Cannot build FilterIn, some of required attributes are not set " + attributes;
        }
    }
}

