/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.filter;

import io.deephaven.api.expression.Expression;
import io.deephaven.api.filter.FilterPattern;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FilterPattern", generator="Immutables")
@Immutable
final class ImmutableFilterPattern
extends FilterPattern {
    private final Expression expression;
    private final Pattern pattern;
    private final FilterPattern.Mode mode;
    private final boolean invertPattern;

    private ImmutableFilterPattern(Builder builder) {
        this.expression = builder.expression;
        this.pattern = builder.pattern;
        this.mode = builder.mode;
        this.invertPattern = builder.invertPatternIsSet() ? builder.invertPattern : super.invertPattern();
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public Pattern pattern() {
        return this.pattern;
    }

    @Override
    public FilterPattern.Mode mode() {
        return this.mode;
    }

    @Override
    public boolean invertPattern() {
        return this.invertPattern;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FilterPattern", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements FilterPattern.Builder {
        private static final long INIT_BIT_EXPRESSION = 1L;
        private static final long INIT_BIT_PATTERN = 2L;
        private static final long INIT_BIT_MODE = 4L;
        private static final long OPT_BIT_INVERT_PATTERN = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private Expression expression;
        @Nullable
        private Pattern pattern;
        @Nullable
        private FilterPattern.Mode mode;
        private boolean invertPattern;

        private Builder() {
        }

        @Override
        public final Builder expression(Expression expression) {
            Builder.checkNotIsSet(this.expressionIsSet(), "expression");
            this.expression = Objects.requireNonNull(expression, "expression");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder pattern(Pattern pattern) {
            Builder.checkNotIsSet(this.patternIsSet(), "pattern");
            this.pattern = Objects.requireNonNull(pattern, "pattern");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public final Builder mode(FilterPattern.Mode mode) {
            Builder.checkNotIsSet(this.modeIsSet(), "mode");
            this.mode = Objects.requireNonNull(mode, "mode");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public final Builder invertPattern(boolean invertPattern) {
            Builder.checkNotIsSet(this.invertPatternIsSet(), "invertPattern");
            this.invertPattern = invertPattern;
            this.optBits |= 1L;
            return this;
        }

        @Override
        public ImmutableFilterPattern build() {
            this.checkRequiredAttributes();
            return new ImmutableFilterPattern(this);
        }

        private boolean invertPatternIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean expressionIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean patternIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean modeIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of FilterPattern is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.expressionIsSet()) {
                attributes.add("expression");
            }
            if (!this.patternIsSet()) {
                attributes.add("pattern");
            }
            if (!this.modeIsSet()) {
                attributes.add("mode");
            }
            return "Cannot build FilterPattern, some of required attributes are not set " + attributes;
        }
    }
}

