/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.literal;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.literal.ImmutableLiteralChar;
import io.deephaven.api.literal.Literal;
import io.deephaven.api.literal.LiteralBase;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
abstract class LiteralChar
extends LiteralBase {
    LiteralChar() {
    }

    public static LiteralChar of(char value) {
        return ImmutableLiteralChar.of(value);
    }

    @Value.Parameter
    public abstract char value();

    @Override
    public final <T> T walk(Literal.Visitor<T> visitor) {
        return visitor.visit(this.value());
    }

    @Value.Check
    final void checkNotDeephavenNull() {
        if (this.value() == '\uffff') {
            throw new IllegalArgumentException("Can't represent QueryConstants.NULL_CHAR, is Deephaven null representation");
        }
    }
}

