/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.literal;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.literal.ImmutableLiteralInt;
import io.deephaven.api.literal.Literal;
import io.deephaven.api.literal.LiteralBase;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
abstract class LiteralInt
extends LiteralBase {
    LiteralInt() {
    }

    public static LiteralInt of(int value) {
        return ImmutableLiteralInt.of(value);
    }

    @Value.Parameter
    public abstract int value();

    @Override
    public final <T> T walk(Literal.Visitor<T> visitor) {
        return visitor.visit(this.value());
    }

    @Value.Check
    final void checkNotDeephavenNull() {
        if (this.value() == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Can't represent QueryConstants.NULL_INT, is Deephaven null representation");
        }
    }
}

