/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.object;

import io.deephaven.api.object.UnionObjectBase;
import java.util.Objects;

public interface UnionObject {
    public static UnionObject of(final boolean x) {
        return new UnionObjectBase(){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visit(x);
            }
        };
    }

    public static UnionObject of(final char x) {
        return new UnionObjectBase(){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visit(x);
            }
        };
    }

    public static UnionObject of(final byte x) {
        return new UnionObjectBase(){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visit(x);
            }
        };
    }

    public static UnionObject of(final short x) {
        return new UnionObjectBase(){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visit(x);
            }
        };
    }

    public static UnionObject of(final int x) {
        return new UnionObjectBase(){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visit(x);
            }
        };
    }

    public static UnionObject of(final long x) {
        return new UnionObjectBase(){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visit(x);
            }
        };
    }

    public static UnionObject of(final float x) {
        return new UnionObjectBase(){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visit(x);
            }
        };
    }

    public static UnionObject of(final double x) {
        return new UnionObjectBase(){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visit(x);
            }
        };
    }

    public static UnionObject of(final Object x) {
        Objects.requireNonNull(x);
        if (UnionObjectBase.isBoxedPrimitive(x.getClass())) {
            throw new IllegalArgumentException(String.format("Object is boxed type %s, must use UnionObject#from, or more appropriate primitive method #of", x.getClass()));
        }
        return new UnionObjectBase(){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visit(x);
            }
        };
    }

    public static UnionObject from(Object x) {
        if (x instanceof Boolean) {
            return UnionObject.of((Boolean)x);
        }
        if (x instanceof Character) {
            return UnionObject.of(((Character)x).charValue());
        }
        if (x instanceof Byte) {
            return UnionObject.of((Byte)x);
        }
        if (x instanceof Short) {
            return UnionObject.of((Short)x);
        }
        if (x instanceof Integer) {
            return UnionObject.of((Integer)x);
        }
        if (x instanceof Long) {
            return UnionObject.of((Long)x);
        }
        if (x instanceof Float) {
            return UnionObject.of(((Float)x).floatValue());
        }
        if (x instanceof Double) {
            return UnionObject.of((Double)x);
        }
        return UnionObject.of(x);
    }

    public Object unwrap();

    public <T> T expect(Class<T> var1) throws IllegalArgumentException;

    public Number number() throws IllegalArgumentException;

    public boolean booleanValue();

    public char charValue();

    public byte byteValue();

    public short shortValue();

    public int intValue();

    public long longValue();

    public float floatValue();

    public double doubleValue();

    public <T> T visit(Visitor<T> var1);

    public static interface Visitor<T> {
        public T visit(boolean var1);

        public T visit(char var1);

        public T visit(byte var1);

        public T visit(short var1);

        public T visit(int var1);

        public T visit(long var1);

        public T visit(float var1);

        public T visit(double var1);

        public T visit(Object var1);
    }
}

