/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby;

import io.deephaven.api.updateby.UpdateByControl;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UpdateByControl", generator="Immutables")
@Immutable
final class ImmutableUpdateByControl
extends UpdateByControl {
    @Nullable
    private final Boolean useRedirection;
    @Nullable
    private final Integer chunkCapacity;
    @Nullable
    private final Double maxStaticSparseMemoryOverhead;
    @Nullable
    private final Integer initialHashTableSize;
    @Nullable
    private final Double maximumLoadFactor;
    @Nullable
    private final Double targetLoadFactor;
    @Nullable
    private final MathContext mathContext;
    private final transient boolean useRedirectionOrDefault;
    private final transient int chunkCapacityOrDefault;
    private final transient double maxStaticSparseMemoryOverheadOrDefault;
    private final transient int initialHashTableSizeOrDefault;
    private final transient double maximumLoadFactorOrDefault;
    private final transient double targetLoadFactorOrDefault;
    private final transient MathContext mathContextOrDefault;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateByControl(Builder builder) {
        this.useRedirection = builder.useRedirection;
        this.chunkCapacity = builder.chunkCapacity;
        this.maxStaticSparseMemoryOverhead = builder.maxStaticSparseMemoryOverhead;
        this.initialHashTableSize = builder.initialHashTableSize;
        this.maximumLoadFactor = builder.maximumLoadFactor;
        this.targetLoadFactor = builder.targetLoadFactor;
        this.mathContext = builder.mathContext;
        this.useRedirectionOrDefault = this.initShim.useRedirectionOrDefault();
        this.chunkCapacityOrDefault = this.initShim.chunkCapacityOrDefault();
        this.maxStaticSparseMemoryOverheadOrDefault = this.initShim.maxStaticSparseMemoryOverheadOrDefault();
        this.initialHashTableSizeOrDefault = this.initShim.initialHashTableSizeOrDefault();
        this.maximumLoadFactorOrDefault = this.initShim.maximumLoadFactorOrDefault();
        this.targetLoadFactorOrDefault = this.initShim.targetLoadFactorOrDefault();
        this.mathContextOrDefault = this.initShim.mathContextOrDefault();
        this.initShim = null;
    }

    @Override
    @Nullable
    public Boolean useRedirection() {
        return this.useRedirection;
    }

    @Override
    public OptionalInt chunkCapacity() {
        return this.chunkCapacity != null ? OptionalInt.of(this.chunkCapacity) : OptionalInt.empty();
    }

    @Override
    public OptionalDouble maxStaticSparseMemoryOverhead() {
        return this.maxStaticSparseMemoryOverhead != null ? OptionalDouble.of(this.maxStaticSparseMemoryOverhead) : OptionalDouble.empty();
    }

    @Override
    public OptionalInt initialHashTableSize() {
        return this.initialHashTableSize != null ? OptionalInt.of(this.initialHashTableSize) : OptionalInt.empty();
    }

    @Override
    public OptionalDouble maximumLoadFactor() {
        return this.maximumLoadFactor != null ? OptionalDouble.of(this.maximumLoadFactor) : OptionalDouble.empty();
    }

    @Override
    public OptionalDouble targetLoadFactor() {
        return this.targetLoadFactor != null ? OptionalDouble.of(this.targetLoadFactor) : OptionalDouble.empty();
    }

    @Override
    public Optional<MathContext> mathContext() {
        return Optional.ofNullable(this.mathContext);
    }

    @Override
    public boolean useRedirectionOrDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useRedirectionOrDefault() : this.useRedirectionOrDefault;
    }

    @Override
    public int chunkCapacityOrDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.chunkCapacityOrDefault() : this.chunkCapacityOrDefault;
    }

    @Override
    public double maxStaticSparseMemoryOverheadOrDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxStaticSparseMemoryOverheadOrDefault() : this.maxStaticSparseMemoryOverheadOrDefault;
    }

    @Override
    public int initialHashTableSizeOrDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.initialHashTableSizeOrDefault() : this.initialHashTableSizeOrDefault;
    }

    @Override
    public double maximumLoadFactorOrDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maximumLoadFactorOrDefault() : this.maximumLoadFactorOrDefault;
    }

    @Override
    public double targetLoadFactorOrDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.targetLoadFactorOrDefault() : this.targetLoadFactorOrDefault;
    }

    @Override
    public MathContext mathContextOrDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mathContextOrDefault() : this.mathContextOrDefault;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateByControl && this.equalTo(0, (ImmutableUpdateByControl)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateByControl another) {
        return Objects.equals(this.useRedirection, another.useRedirection) && Objects.equals(this.chunkCapacity, another.chunkCapacity) && Objects.equals(this.maxStaticSparseMemoryOverhead, another.maxStaticSparseMemoryOverhead) && Objects.equals(this.initialHashTableSize, another.initialHashTableSize) && Objects.equals(this.maximumLoadFactor, another.maximumLoadFactor) && Objects.equals(this.targetLoadFactor, another.targetLoadFactor) && Objects.equals(this.mathContext, another.mathContext) && this.useRedirectionOrDefault == another.useRedirectionOrDefault && this.chunkCapacityOrDefault == another.chunkCapacityOrDefault && Double.doubleToLongBits(this.maxStaticSparseMemoryOverheadOrDefault) == Double.doubleToLongBits(another.maxStaticSparseMemoryOverheadOrDefault) && this.initialHashTableSizeOrDefault == another.initialHashTableSizeOrDefault && Double.doubleToLongBits(this.maximumLoadFactorOrDefault) == Double.doubleToLongBits(another.maximumLoadFactorOrDefault) && Double.doubleToLongBits(this.targetLoadFactorOrDefault) == Double.doubleToLongBits(another.targetLoadFactorOrDefault) && this.mathContextOrDefault.equals(another.mathContextOrDefault);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + Objects.hashCode(this.useRedirection);
        h += (h << 5) + Objects.hashCode(this.chunkCapacity);
        h += (h << 5) + Objects.hashCode(this.maxStaticSparseMemoryOverhead);
        h += (h << 5) + Objects.hashCode(this.initialHashTableSize);
        h += (h << 5) + Objects.hashCode(this.maximumLoadFactor);
        h += (h << 5) + Objects.hashCode(this.targetLoadFactor);
        h += (h << 5) + Objects.hashCode(this.mathContext);
        h += (h << 5) + Boolean.hashCode(this.useRedirectionOrDefault);
        h += (h << 5) + this.chunkCapacityOrDefault;
        h += (h << 5) + Double.hashCode(this.maxStaticSparseMemoryOverheadOrDefault);
        h += (h << 5) + this.initialHashTableSizeOrDefault;
        h += (h << 5) + Double.hashCode(this.maximumLoadFactorOrDefault);
        h += (h << 5) + Double.hashCode(this.targetLoadFactorOrDefault);
        h += (h << 5) + this.mathContextOrDefault.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UpdateByControl{");
        if (this.useRedirection != null) {
            builder.append("useRedirection=").append(this.useRedirection);
        }
        if (this.chunkCapacity != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("chunkCapacity=").append(this.chunkCapacity);
        }
        if (this.maxStaticSparseMemoryOverhead != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("maxStaticSparseMemoryOverhead=").append(this.maxStaticSparseMemoryOverhead);
        }
        if (this.initialHashTableSize != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("initialHashTableSize=").append(this.initialHashTableSize);
        }
        if (this.maximumLoadFactor != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("maximumLoadFactor=").append(this.maximumLoadFactor);
        }
        if (this.targetLoadFactor != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("targetLoadFactor=").append(this.targetLoadFactor);
        }
        if (this.mathContext != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("mathContext=").append(this.mathContext);
        }
        if (builder.length() > 16) {
            builder.append(", ");
        }
        builder.append("useRedirectionOrDefault=").append(this.useRedirectionOrDefault);
        builder.append(", ");
        builder.append("chunkCapacityOrDefault=").append(this.chunkCapacityOrDefault);
        builder.append(", ");
        builder.append("maxStaticSparseMemoryOverheadOrDefault=").append(this.maxStaticSparseMemoryOverheadOrDefault);
        builder.append(", ");
        builder.append("initialHashTableSizeOrDefault=").append(this.initialHashTableSizeOrDefault);
        builder.append(", ");
        builder.append("maximumLoadFactorOrDefault=").append(this.maximumLoadFactorOrDefault);
        builder.append(", ");
        builder.append("targetLoadFactorOrDefault=").append(this.targetLoadFactorOrDefault);
        builder.append(", ");
        builder.append("mathContextOrDefault=").append(this.mathContextOrDefault);
        return builder.append("}").toString();
    }

    private static ImmutableUpdateByControl validate(ImmutableUpdateByControl instance) {
        instance.checkTargetLTEMaximum();
        instance.checkTargetLoadFactor();
        instance.checkMaximumLoadFactor();
        instance.checkInitialHashTableSize();
        instance.checkChunkCapacity();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UpdateByControl", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements UpdateByControl.Builder {
        private static final long OPT_BIT_USE_REDIRECTION = 1L;
        private static final long OPT_BIT_CHUNK_CAPACITY = 2L;
        private static final long OPT_BIT_MAX_STATIC_SPARSE_MEMORY_OVERHEAD = 4L;
        private static final long OPT_BIT_INITIAL_HASH_TABLE_SIZE = 8L;
        private static final long OPT_BIT_MAXIMUM_LOAD_FACTOR = 16L;
        private static final long OPT_BIT_TARGET_LOAD_FACTOR = 32L;
        private static final long OPT_BIT_MATH_CONTEXT = 64L;
        private long optBits;
        @Nullable
        private Boolean useRedirection;
        @Nullable
        private Integer chunkCapacity;
        @Nullable
        private Double maxStaticSparseMemoryOverhead;
        @Nullable
        private Integer initialHashTableSize;
        @Nullable
        private Double maximumLoadFactor;
        @Nullable
        private Double targetLoadFactor;
        @Nullable
        private MathContext mathContext;

        private Builder() {
        }

        @Override
        public final Builder useRedirection(@Nullable Boolean useRedirection) {
            Builder.checkNotIsSet(this.useRedirectionIsSet(), "useRedirection");
            this.useRedirection = useRedirection;
            this.optBits |= 1L;
            return this;
        }

        @Override
        public final Builder chunkCapacity(int chunkCapacity) {
            Builder.checkNotIsSet(this.chunkCapacityIsSet(), "chunkCapacity");
            this.chunkCapacity = chunkCapacity;
            this.optBits |= 2L;
            return this;
        }

        public final Builder chunkCapacity(OptionalInt chunkCapacity) {
            Builder.checkNotIsSet(this.chunkCapacityIsSet(), "chunkCapacity");
            this.chunkCapacity = chunkCapacity.isPresent() ? Integer.valueOf(chunkCapacity.getAsInt()) : null;
            this.optBits |= 2L;
            return this;
        }

        @Override
        public final Builder maxStaticSparseMemoryOverhead(double maxStaticSparseMemoryOverhead) {
            Builder.checkNotIsSet(this.maxStaticSparseMemoryOverheadIsSet(), "maxStaticSparseMemoryOverhead");
            this.maxStaticSparseMemoryOverhead = maxStaticSparseMemoryOverhead;
            this.optBits |= 4L;
            return this;
        }

        public final Builder maxStaticSparseMemoryOverhead(OptionalDouble maxStaticSparseMemoryOverhead) {
            Builder.checkNotIsSet(this.maxStaticSparseMemoryOverheadIsSet(), "maxStaticSparseMemoryOverhead");
            this.maxStaticSparseMemoryOverhead = maxStaticSparseMemoryOverhead.isPresent() ? Double.valueOf(maxStaticSparseMemoryOverhead.getAsDouble()) : null;
            this.optBits |= 4L;
            return this;
        }

        @Override
        public final Builder initialHashTableSize(int initialHashTableSize) {
            Builder.checkNotIsSet(this.initialHashTableSizeIsSet(), "initialHashTableSize");
            this.initialHashTableSize = initialHashTableSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder initialHashTableSize(OptionalInt initialHashTableSize) {
            Builder.checkNotIsSet(this.initialHashTableSizeIsSet(), "initialHashTableSize");
            this.initialHashTableSize = initialHashTableSize.isPresent() ? Integer.valueOf(initialHashTableSize.getAsInt()) : null;
            this.optBits |= 8L;
            return this;
        }

        @Override
        public final Builder maximumLoadFactor(double maximumLoadFactor) {
            Builder.checkNotIsSet(this.maximumLoadFactorIsSet(), "maximumLoadFactor");
            this.maximumLoadFactor = maximumLoadFactor;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder maximumLoadFactor(OptionalDouble maximumLoadFactor) {
            Builder.checkNotIsSet(this.maximumLoadFactorIsSet(), "maximumLoadFactor");
            this.maximumLoadFactor = maximumLoadFactor.isPresent() ? Double.valueOf(maximumLoadFactor.getAsDouble()) : null;
            this.optBits |= 0x10L;
            return this;
        }

        @Override
        public final Builder targetLoadFactor(double targetLoadFactor) {
            Builder.checkNotIsSet(this.targetLoadFactorIsSet(), "targetLoadFactor");
            this.targetLoadFactor = targetLoadFactor;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder targetLoadFactor(OptionalDouble targetLoadFactor) {
            Builder.checkNotIsSet(this.targetLoadFactorIsSet(), "targetLoadFactor");
            this.targetLoadFactor = targetLoadFactor.isPresent() ? Double.valueOf(targetLoadFactor.getAsDouble()) : null;
            this.optBits |= 0x20L;
            return this;
        }

        @Override
        public final Builder mathContext(MathContext mathContext) {
            Builder.checkNotIsSet(this.mathContextIsSet(), "mathContext");
            this.mathContext = Objects.requireNonNull(mathContext, "mathContext");
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder mathContext(Optional<? extends MathContext> mathContext) {
            Builder.checkNotIsSet(this.mathContextIsSet(), "mathContext");
            this.mathContext = mathContext.orElse(null);
            this.optBits |= 0x40L;
            return this;
        }

        @Override
        public ImmutableUpdateByControl build() {
            return ImmutableUpdateByControl.validate(new ImmutableUpdateByControl(this));
        }

        private boolean useRedirectionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean chunkCapacityIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean maxStaticSparseMemoryOverheadIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean initialHashTableSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean maximumLoadFactorIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean targetLoadFactorIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean mathContextIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of UpdateByControl is strict, attribute is already set: ".concat(name));
            }
        }
    }

    @Generated(from="UpdateByControl", generator="Immutables")
    private final class InitShim {
        private byte useRedirectionOrDefaultBuildStage = 0;
        private boolean useRedirectionOrDefault;
        private byte chunkCapacityOrDefaultBuildStage = 0;
        private int chunkCapacityOrDefault;
        private byte maxStaticSparseMemoryOverheadOrDefaultBuildStage = 0;
        private double maxStaticSparseMemoryOverheadOrDefault;
        private byte initialHashTableSizeOrDefaultBuildStage = 0;
        private int initialHashTableSizeOrDefault;
        private byte maximumLoadFactorOrDefaultBuildStage = 0;
        private double maximumLoadFactorOrDefault;
        private byte targetLoadFactorOrDefaultBuildStage = 0;
        private double targetLoadFactorOrDefault;
        private byte mathContextOrDefaultBuildStage = 0;
        private MathContext mathContextOrDefault;

        private InitShim() {
        }

        boolean useRedirectionOrDefault() {
            if (this.useRedirectionOrDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useRedirectionOrDefaultBuildStage == 0) {
                this.useRedirectionOrDefaultBuildStage = (byte)-1;
                this.useRedirectionOrDefault = ImmutableUpdateByControl.super.useRedirectionOrDefault();
                this.useRedirectionOrDefaultBuildStage = 1;
            }
            return this.useRedirectionOrDefault;
        }

        int chunkCapacityOrDefault() {
            if (this.chunkCapacityOrDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.chunkCapacityOrDefaultBuildStage == 0) {
                this.chunkCapacityOrDefaultBuildStage = (byte)-1;
                this.chunkCapacityOrDefault = ImmutableUpdateByControl.super.chunkCapacityOrDefault();
                this.chunkCapacityOrDefaultBuildStage = 1;
            }
            return this.chunkCapacityOrDefault;
        }

        double maxStaticSparseMemoryOverheadOrDefault() {
            if (this.maxStaticSparseMemoryOverheadOrDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxStaticSparseMemoryOverheadOrDefaultBuildStage == 0) {
                this.maxStaticSparseMemoryOverheadOrDefaultBuildStage = (byte)-1;
                this.maxStaticSparseMemoryOverheadOrDefault = ImmutableUpdateByControl.super.maxStaticSparseMemoryOverheadOrDefault();
                this.maxStaticSparseMemoryOverheadOrDefaultBuildStage = 1;
            }
            return this.maxStaticSparseMemoryOverheadOrDefault;
        }

        int initialHashTableSizeOrDefault() {
            if (this.initialHashTableSizeOrDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initialHashTableSizeOrDefaultBuildStage == 0) {
                this.initialHashTableSizeOrDefaultBuildStage = (byte)-1;
                this.initialHashTableSizeOrDefault = ImmutableUpdateByControl.super.initialHashTableSizeOrDefault();
                this.initialHashTableSizeOrDefaultBuildStage = 1;
            }
            return this.initialHashTableSizeOrDefault;
        }

        double maximumLoadFactorOrDefault() {
            if (this.maximumLoadFactorOrDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maximumLoadFactorOrDefaultBuildStage == 0) {
                this.maximumLoadFactorOrDefaultBuildStage = (byte)-1;
                this.maximumLoadFactorOrDefault = ImmutableUpdateByControl.super.maximumLoadFactorOrDefault();
                this.maximumLoadFactorOrDefaultBuildStage = 1;
            }
            return this.maximumLoadFactorOrDefault;
        }

        double targetLoadFactorOrDefault() {
            if (this.targetLoadFactorOrDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.targetLoadFactorOrDefaultBuildStage == 0) {
                this.targetLoadFactorOrDefaultBuildStage = (byte)-1;
                this.targetLoadFactorOrDefault = ImmutableUpdateByControl.super.targetLoadFactorOrDefault();
                this.targetLoadFactorOrDefaultBuildStage = 1;
            }
            return this.targetLoadFactorOrDefault;
        }

        MathContext mathContextOrDefault() {
            if (this.mathContextOrDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mathContextOrDefaultBuildStage == 0) {
                this.mathContextOrDefaultBuildStage = (byte)-1;
                this.mathContextOrDefault = Objects.requireNonNull(ImmutableUpdateByControl.super.mathContextOrDefault(), "mathContextOrDefault");
                this.mathContextOrDefaultBuildStage = 1;
            }
            return this.mathContextOrDefault;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.useRedirectionOrDefaultBuildStage == -1) {
                attributes.add("useRedirectionOrDefault");
            }
            if (this.chunkCapacityOrDefaultBuildStage == -1) {
                attributes.add("chunkCapacityOrDefault");
            }
            if (this.maxStaticSparseMemoryOverheadOrDefaultBuildStage == -1) {
                attributes.add("maxStaticSparseMemoryOverheadOrDefault");
            }
            if (this.initialHashTableSizeOrDefaultBuildStage == -1) {
                attributes.add("initialHashTableSizeOrDefault");
            }
            if (this.maximumLoadFactorOrDefaultBuildStage == -1) {
                attributes.add("maximumLoadFactorOrDefault");
            }
            if (this.targetLoadFactorOrDefaultBuildStage == -1) {
                attributes.add("targetLoadFactorOrDefault");
            }
            if (this.mathContextOrDefaultBuildStage == -1) {
                attributes.add("mathContextOrDefault");
            }
            return "Cannot build UpdateByControl, attribute initializers form cycle " + attributes;
        }
    }
}

