/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.ImmutableUpdateByControl;
import java.math.MathContext;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class UpdateByControl {
    public static final String USE_REDIRECTION_PROPERTY = "UpdateByControl.useRedirection";
    public static final String CHUNK_CAPACITY_PROPERTY = "UpdateByControl.chunkCapacity";
    public static final String MAXIMUM_STATIC_MEMORY_OVERHEAD_PROPERTY = "UpdateByControl.maximumStaticMemoryOverhead";
    public static final String INITIAL_HASH_TABLE_SIZE_PROPERTY = "UpdateByControl.initialHashTableSize";
    public static final String MAXIMUM_LOAD_FACTOR_PROPERTY = "UpdateByControl.maximumLoadFactor";
    public static final String TARGET_LOAD_FACTOR_PROPERTY = "UpdateByControl.targetLoadFactor";
    public static final String MATH_CONTEXT_PROPERTY = "UpdateByControl.mathContext";

    public static Builder builder() {
        return ImmutableUpdateByControl.builder();
    }

    public static UpdateByControl defaultInstance() {
        return UpdateByControl.builder().build();
    }

    public static boolean useRedirectionDefault() {
        return Boolean.getBoolean(USE_REDIRECTION_PROPERTY);
    }

    public static int chunkCapacityDefault() {
        return Integer.getInteger(CHUNK_CAPACITY_PROPERTY, 4096);
    }

    public static double maximumStaticMemoryOverheadDefault() {
        return Double.parseDouble(System.getProperty(MAXIMUM_STATIC_MEMORY_OVERHEAD_PROPERTY, "1.1"));
    }

    public static int initialHashTableSizeDefault() {
        return Integer.getInteger(INITIAL_HASH_TABLE_SIZE_PROPERTY, 4096);
    }

    public static double maximumLoadFactorDefault() {
        return Double.parseDouble(System.getProperty(MAXIMUM_LOAD_FACTOR_PROPERTY, "0.75"));
    }

    public static double targetLoadFactorDefault() {
        return Double.parseDouble(System.getProperty(TARGET_LOAD_FACTOR_PROPERTY, "0.7"));
    }

    public static MathContext mathContextDefault() {
        String p;
        switch (p = System.getProperty(MATH_CONTEXT_PROPERTY, "DECIMAL64")) {
            case "UNLIMITED": {
                return MathContext.UNLIMITED;
            }
            case "DECIMAL32": {
                return MathContext.DECIMAL32;
            }
            case "DECIMAL64": {
                return MathContext.DECIMAL64;
            }
            case "DECIMAL128": {
                return MathContext.DECIMAL128;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected '%s': %s", MATH_CONTEXT_PROPERTY, p));
    }

    @Nullable
    public abstract Boolean useRedirection();

    public abstract OptionalInt chunkCapacity();

    public abstract OptionalDouble maxStaticSparseMemoryOverhead();

    public abstract OptionalInt initialHashTableSize();

    public abstract OptionalDouble maximumLoadFactor();

    public abstract OptionalDouble targetLoadFactor();

    public abstract Optional<MathContext> mathContext();

    @Value.Derived
    public boolean useRedirectionOrDefault() {
        Boolean useRedirection = this.useRedirection();
        return useRedirection == null ? UpdateByControl.useRedirectionDefault() : useRedirection;
    }

    @Value.Derived
    public int chunkCapacityOrDefault() {
        return this.chunkCapacity().orElseGet(UpdateByControl::chunkCapacityDefault);
    }

    @Value.Derived
    public double maxStaticSparseMemoryOverheadOrDefault() {
        return this.maxStaticSparseMemoryOverhead().orElseGet(UpdateByControl::maximumStaticMemoryOverheadDefault);
    }

    @Value.Derived
    public int initialHashTableSizeOrDefault() {
        return this.initialHashTableSize().orElseGet(UpdateByControl::initialHashTableSizeDefault);
    }

    @Value.Derived
    public double maximumLoadFactorOrDefault() {
        return this.maximumLoadFactor().orElseGet(UpdateByControl::maximumLoadFactorDefault);
    }

    @Value.Derived
    public double targetLoadFactorOrDefault() {
        return this.targetLoadFactor().orElseGet(UpdateByControl::targetLoadFactorDefault);
    }

    @Value.Derived
    public MathContext mathContextOrDefault() {
        return this.mathContext().orElseGet(UpdateByControl::mathContextDefault);
    }

    public final UpdateByControl materialize() {
        return UpdateByControl.builder().useRedirection(this.useRedirectionOrDefault()).chunkCapacity(this.chunkCapacityOrDefault()).maxStaticSparseMemoryOverhead(this.maxStaticSparseMemoryOverheadOrDefault()).initialHashTableSize(this.initialHashTableSizeOrDefault()).maximumLoadFactor(this.maximumLoadFactorOrDefault()).targetLoadFactor(this.targetLoadFactorOrDefault()).mathContext(this.mathContextOrDefault()).build();
    }

    @Value.Check
    final void checkChunkCapacity() {
        if (this.chunkCapacityOrDefault() <= 0) {
            throw new IllegalArgumentException(String.format("UpdateByControl.chunkCapacity() must be greater than 0, is %d", this.chunkCapacityOrDefault()));
        }
    }

    @Value.Check
    final void checkInitialHashTableSize() {
        if (this.initialHashTableSizeOrDefault() <= 0) {
            throw new IllegalArgumentException(String.format("UpdateByControl.initialHashTableSize() must be greater than 0, is %d", this.initialHashTableSizeOrDefault()));
        }
    }

    @Value.Check
    final void checkMaximumLoadFactor() {
        if (Double.isNaN(this.maximumLoadFactorOrDefault()) || this.maximumLoadFactorOrDefault() <= 0.0 || this.maximumLoadFactorOrDefault() >= 1.0) {
            throw new IllegalArgumentException(String.format("UpdateByControl.maximumLoadFactor() must be in the range (0.0, 1.0), is %f", this.maximumLoadFactorOrDefault()));
        }
    }

    @Value.Check
    final void checkTargetLoadFactor() {
        if (Double.isNaN(this.targetLoadFactorOrDefault()) || this.targetLoadFactorOrDefault() <= 0.0 || this.targetLoadFactorOrDefault() >= 1.0) {
            throw new IllegalArgumentException(String.format("UpdateByControl.targetLoadFactor() must be in the range (0.0, 1.0), is %f", this.targetLoadFactorOrDefault()));
        }
    }

    @Value.Check
    final void checkTargetLTEMaximum() {
        if (this.targetLoadFactorOrDefault() > this.maximumLoadFactorOrDefault()) {
            throw new IllegalArgumentException(String.format("UpdateByControl.targetLoadFactor() must be less than or equal to UpdateByControl.maximumLoadFactor(). targetLoadFactor=%f, maximumLoadFactor=%f", this.targetLoadFactorOrDefault(), this.maximumLoadFactorOrDefault()));
        }
    }

    public static interface Builder {
        public Builder useRedirection(Boolean var1);

        public Builder chunkCapacity(int var1);

        public Builder maxStaticSparseMemoryOverhead(double var1);

        public Builder initialHashTableSize(int var1);

        public Builder maximumLoadFactor(double var1);

        public Builder targetLoadFactor(double var1);

        public Builder mathContext(MathContext var1);

        public UpdateByControl build();
    }
}

