/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.OperationControl;
import io.deephaven.api.updateby.spec.ImmutableEmStdSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.UpdateBySpecBase;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class EmStdSpec
extends UpdateBySpecBase {
    public static EmStdSpec of(OperationControl control, WindowScale windowScale) {
        return ImmutableEmStdSpec.builder().control(control).windowScale(windowScale).build();
    }

    public static EmStdSpec of(WindowScale windowScale) {
        return ImmutableEmStdSpec.builder().windowScale(windowScale).build();
    }

    public static EmStdSpec ofTime(OperationControl control, String timestampCol, long timeScaleNanos) {
        return EmStdSpec.of(control, WindowScale.ofTime(timestampCol, timeScaleNanos));
    }

    public static EmStdSpec ofTime(String timestampCol, long timeScaleNanos) {
        return EmStdSpec.of(WindowScale.ofTime(timestampCol, timeScaleNanos));
    }

    public static EmStdSpec ofTime(OperationControl control, String timestampCol, Duration emaDuration) {
        return EmStdSpec.of(control, WindowScale.ofTime(timestampCol, emaDuration));
    }

    public static EmStdSpec ofTime(String timestampCol, Duration emaDuration) {
        return EmStdSpec.of(WindowScale.ofTime(timestampCol, emaDuration));
    }

    public static EmStdSpec ofTicks(OperationControl control, double tickWindow) {
        return EmStdSpec.of(control, WindowScale.ofTicks(tickWindow));
    }

    public static EmStdSpec ofTicks(double tickWindow) {
        return EmStdSpec.of(WindowScale.ofTicks(tickWindow));
    }

    public abstract Optional<OperationControl> control();

    public abstract WindowScale windowScale();

    public final OperationControl controlOrDefault() {
        return this.control().orElseGet(OperationControl::defaultInstance);
    }

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return EmStdSpec.applicableToNumeric(inputType) || inputType == Character.TYPE || inputType == Character.class;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

