/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.OperationControl;
import io.deephaven.api.updateby.spec.ImmutableEmsSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.UpdateBySpecBase;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class EmsSpec
extends UpdateBySpecBase {
    public static EmsSpec of(OperationControl control, WindowScale windowScale) {
        return ImmutableEmsSpec.builder().control(control).windowScale(windowScale).build();
    }

    public static EmsSpec of(WindowScale windowScale) {
        return ImmutableEmsSpec.builder().windowScale(windowScale).build();
    }

    public static EmsSpec ofTime(OperationControl control, String timestampCol, long timeScaleNanos) {
        return EmsSpec.of(control, WindowScale.ofTime(timestampCol, timeScaleNanos));
    }

    public static EmsSpec ofTime(String timestampCol, long timeScaleNanos) {
        return EmsSpec.of(WindowScale.ofTime(timestampCol, timeScaleNanos));
    }

    public static EmsSpec ofTime(OperationControl control, String timestampCol, Duration emaDuration) {
        return EmsSpec.of(control, WindowScale.ofTime(timestampCol, emaDuration));
    }

    public static EmsSpec ofTime(String timestampCol, Duration emaDuration) {
        return EmsSpec.of(WindowScale.ofTime(timestampCol, emaDuration));
    }

    public static EmsSpec ofTicks(OperationControl control, double tickWindow) {
        return EmsSpec.of(control, WindowScale.ofTicks(tickWindow));
    }

    public static EmsSpec ofTicks(double tickWindow) {
        return EmsSpec.of(WindowScale.ofTicks(tickWindow));
    }

    public abstract Optional<OperationControl> control();

    public abstract WindowScale windowScale();

    public final OperationControl controlOrDefault() {
        return this.control().orElseGet(OperationControl::defaultInstance);
    }

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return EmsSpec.applicableToNumeric(inputType) || inputType == Character.TYPE || inputType == Character.class;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

