/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.spec.ImmutableRollingAvgSpec;
import io.deephaven.api.updateby.spec.RollingOpSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class RollingAvgSpec
extends RollingOpSpec {
    public static RollingAvgSpec ofTicks(long revTicks) {
        return RollingAvgSpec.of(WindowScale.ofTicks(revTicks));
    }

    public static RollingAvgSpec ofTicks(long revTicks, long fwdTicks) {
        return RollingAvgSpec.of(WindowScale.ofTicks(revTicks), WindowScale.ofTicks(fwdTicks));
    }

    public static RollingAvgSpec ofTime(String timestampCol, Duration revDuration) {
        return RollingAvgSpec.of(WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingAvgSpec ofTime(String timestampCol, Duration revDuration, Duration fwdDuration) {
        return RollingAvgSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingAvgSpec ofTime(String timestampCol, long revDuration) {
        return RollingAvgSpec.of(WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingAvgSpec ofTime(String timestampCol, long revDuration, long fwdDuration) {
        return RollingAvgSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingAvgSpec of(WindowScale revWindowScale) {
        return ImmutableRollingAvgSpec.builder().revWindowScale(revWindowScale).build();
    }

    public static RollingAvgSpec of(WindowScale revWindowScale, WindowScale fwdWindowScale) {
        return ImmutableRollingAvgSpec.builder().revWindowScale(revWindowScale).fwdWindowScale(fwdWindowScale).build();
    }

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return RollingAvgSpec.applicableToNumeric(inputType) || inputType == Character.TYPE || inputType == Character.class || inputType == Boolean.TYPE || inputType == Boolean.class;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

