/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.spec.ImmutableRollingGroupSpec;
import io.deephaven.api.updateby.spec.RollingOpSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class RollingGroupSpec
extends RollingOpSpec {
    public static RollingGroupSpec ofTicks(long revTicks) {
        return RollingGroupSpec.of(WindowScale.ofTicks(revTicks));
    }

    public static RollingGroupSpec ofTicks(long revTicks, long fwdTicks) {
        return RollingGroupSpec.of(WindowScale.ofTicks(revTicks), WindowScale.ofTicks(fwdTicks));
    }

    public static RollingGroupSpec ofTime(String timestampCol, Duration revDuration) {
        return RollingGroupSpec.of(WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingGroupSpec ofTime(String timestampCol, Duration revDuration, Duration fwdDuration) {
        return RollingGroupSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingGroupSpec ofTime(String timestampCol, long revDuration) {
        return RollingGroupSpec.of(WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingGroupSpec ofTime(String timestampCol, long revDuration, long fwdDuration) {
        return RollingGroupSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingGroupSpec of(WindowScale revWindowScale) {
        return ImmutableRollingGroupSpec.builder().revWindowScale(revWindowScale).build();
    }

    public static RollingGroupSpec of(WindowScale revWindowScale, WindowScale fwdWindowScale) {
        return ImmutableRollingGroupSpec.builder().revWindowScale(revWindowScale).fwdWindowScale(fwdWindowScale).build();
    }

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return true;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

