/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.spec.ImmutableRollingMinMaxSpec;
import io.deephaven.api.updateby.spec.RollingOpSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class RollingMinMaxSpec
extends RollingOpSpec {
    public static RollingMinMaxSpec ofTicks(boolean isMax, long revTicks) {
        return RollingMinMaxSpec.of(isMax, WindowScale.ofTicks(revTicks));
    }

    public static RollingMinMaxSpec ofTicks(boolean isMax, long revTicks, long fwdTicks) {
        return RollingMinMaxSpec.of(isMax, WindowScale.ofTicks(revTicks), WindowScale.ofTicks(fwdTicks));
    }

    public static RollingMinMaxSpec ofTime(boolean isMax, String timestampCol, Duration revDuration) {
        return RollingMinMaxSpec.of(isMax, WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingMinMaxSpec ofTime(boolean isMax, String timestampCol, Duration revDuration, Duration fwdDuration) {
        return RollingMinMaxSpec.of(isMax, WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingMinMaxSpec ofTime(boolean isMax, String timestampCol, long revDuration) {
        return RollingMinMaxSpec.of(isMax, WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingMinMaxSpec ofTime(boolean isMax, String timestampCol, long revDuration, long fwdDuration) {
        return RollingMinMaxSpec.of(isMax, WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingMinMaxSpec of(boolean isMax, WindowScale revWindowScale) {
        return ImmutableRollingMinMaxSpec.builder().isMax(isMax).revWindowScale(revWindowScale).build();
    }

    public static RollingMinMaxSpec of(boolean isMax, WindowScale revWindowScale, WindowScale fwdWindowScale) {
        return ImmutableRollingMinMaxSpec.builder().isMax(isMax).revWindowScale(revWindowScale).fwdWindowScale(fwdWindowScale).build();
    }

    public abstract boolean isMax();

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return RollingMinMaxSpec.applicableToNumeric(inputType) || inputType == Character.TYPE || inputType == Character.class || Comparable.class.isAssignableFrom(inputType) && inputType != Boolean.class;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

