/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.api.updateby.spec.UpdateBySpecBase;
import io.deephaven.api.updateby.spec.WindowScale;
import org.immutables.value.Value;

public abstract class RollingOpSpec
extends UpdateBySpecBase {
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    @Value.Default
    public WindowScale revWindowScale() {
        return WindowScale.ofTicks(0.0);
    }

    @Value.Default
    public WindowScale fwdWindowScale() {
        return WindowScale.ofTicks(0.0);
    }

    @Value.Check
    final void checkWindowSizes() {
        double size = this.revWindowScale().getFractionalTimeScaleUnits() + this.fwdWindowScale().getFractionalTimeScaleUnits();
        if (size < 0.0) {
            throw new IllegalArgumentException("UpdateBy rolling window size must be non-negative");
        }
        if (!this.revWindowScale().isTimeBased() && size > 2.147483639E9) {
            throw new IllegalArgumentException("UpdateBy rolling window size may not exceed MAX_ARRAY_SIZE (2147483639)");
        }
    }
}

