/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.spec.ImmutableRollingProductSpec;
import io.deephaven.api.updateby.spec.RollingOpSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class RollingProductSpec
extends RollingOpSpec {
    public static RollingProductSpec ofTicks(long revTicks) {
        return RollingProductSpec.of(WindowScale.ofTicks(revTicks));
    }

    public static RollingProductSpec ofTicks(long revTicks, long fwdTicks) {
        return RollingProductSpec.of(WindowScale.ofTicks(revTicks), WindowScale.ofTicks(fwdTicks));
    }

    public static RollingProductSpec ofTime(String timestampCol, Duration revDuration) {
        return RollingProductSpec.of(WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingProductSpec ofTime(String timestampCol, Duration revDuration, Duration fwdDuration) {
        return RollingProductSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingProductSpec ofTime(String timestampCol, long revDuration) {
        return RollingProductSpec.of(WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingProductSpec ofTime(String timestampCol, long revDuration, long fwdDuration) {
        return RollingProductSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingProductSpec of(WindowScale revWindowScale) {
        return ImmutableRollingProductSpec.builder().revWindowScale(revWindowScale).build();
    }

    public static RollingProductSpec of(WindowScale revWindowScale, WindowScale fwdWindowScale) {
        return ImmutableRollingProductSpec.builder().revWindowScale(revWindowScale).fwdWindowScale(fwdWindowScale).build();
    }

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return RollingProductSpec.applicableToNumeric(inputType) || inputType == Character.TYPE || inputType == Character.class || inputType == Boolean.TYPE || inputType == Boolean.class;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

