/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.spec.ImmutableRollingStdSpec;
import io.deephaven.api.updateby.spec.RollingOpSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class RollingStdSpec
extends RollingOpSpec {
    public static RollingStdSpec ofTicks(long revTicks) {
        return RollingStdSpec.of(WindowScale.ofTicks(revTicks));
    }

    public static RollingStdSpec ofTicks(long revTicks, long fwdTicks) {
        return RollingStdSpec.of(WindowScale.ofTicks(revTicks), WindowScale.ofTicks(fwdTicks));
    }

    public static RollingStdSpec ofTime(String timestampCol, Duration revDuration) {
        return RollingStdSpec.of(WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingStdSpec ofTime(String timestampCol, Duration revDuration, Duration fwdDuration) {
        return RollingStdSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingStdSpec ofTime(String timestampCol, long revDuration) {
        return RollingStdSpec.of(WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingStdSpec ofTime(String timestampCol, long revDuration, long fwdDuration) {
        return RollingStdSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingStdSpec of(WindowScale revWindowScale) {
        return ImmutableRollingStdSpec.builder().revWindowScale(revWindowScale).build();
    }

    public static RollingStdSpec of(WindowScale revWindowScale, WindowScale fwdWindowScale) {
        return ImmutableRollingStdSpec.builder().revWindowScale(revWindowScale).fwdWindowScale(fwdWindowScale).build();
    }

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return RollingStdSpec.applicableToNumeric(inputType) || inputType == Character.TYPE || inputType == Character.class;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

