/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.spec.ImmutableRollingSumSpec;
import io.deephaven.api.updateby.spec.RollingOpSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class RollingSumSpec
extends RollingOpSpec {
    public static RollingSumSpec ofTicks(long revTicks) {
        return RollingSumSpec.of(WindowScale.ofTicks(revTicks));
    }

    public static RollingSumSpec ofTicks(long revTicks, long fwdTicks) {
        return RollingSumSpec.of(WindowScale.ofTicks(revTicks), WindowScale.ofTicks(fwdTicks));
    }

    public static RollingSumSpec ofTime(String timestampCol, Duration revDuration) {
        return RollingSumSpec.of(WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingSumSpec ofTime(String timestampCol, Duration revDuration, Duration fwdDuration) {
        return RollingSumSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingSumSpec ofTime(String timestampCol, long revDuration) {
        return RollingSumSpec.of(WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingSumSpec ofTime(String timestampCol, long revDuration, long fwdDuration) {
        return RollingSumSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingSumSpec of(WindowScale revWindowScale) {
        return ImmutableRollingSumSpec.builder().revWindowScale(revWindowScale).build();
    }

    public static RollingSumSpec of(WindowScale revWindowScale, WindowScale fwdWindowScale) {
        return ImmutableRollingSumSpec.builder().revWindowScale(revWindowScale).fwdWindowScale(fwdWindowScale).build();
    }

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return RollingSumSpec.applicableToNumeric(inputType) || inputType == Character.TYPE || inputType == Character.class || inputType == Boolean.TYPE || inputType == Boolean.class;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

