/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.updateby.spec.ImmutableWindowScale;
import java.time.Duration;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class WindowScale {
    public static WindowScale ofTime(String timestampCol, long timeScaleNanos) {
        return ImmutableWindowScale.of(timestampCol, 0.0, timeScaleNanos);
    }

    public static WindowScale ofTime(String timestampCol, Duration duration) {
        return ImmutableWindowScale.of(timestampCol, 0.0, duration.toNanos());
    }

    public static WindowScale ofTicks(double tickWindow) {
        return ImmutableWindowScale.of(null, tickWindow, 0L);
    }

    @Nullable
    @Value.Parameter
    public abstract String timestampCol();

    @Value.Parameter
    public abstract double tickUnits();

    @Value.Parameter
    public abstract long timeUnits();

    public final boolean isTimeBased() {
        return this.timestampCol() != null;
    }

    public final long getTimeScaleUnits() {
        return this.isTimeBased() ? this.timeUnits() : (long)this.tickUnits();
    }

    public final double getFractionalTimeScaleUnits() {
        return this.isTimeBased() ? (double)this.timeUnits() : this.tickUnits();
    }

    public final Duration getDuration() {
        if (!this.isTimeBased()) {
            throw new IllegalStateException("getDuration() cannot be called on a tick-based Timescale");
        }
        return Duration.ofNanos(this.timeUnits());
    }

    public final long getTicks() {
        if (this.isTimeBased()) {
            throw new IllegalStateException("getTicks() cannot be called on a time-based Timescale");
        }
        return (long)this.tickUnits();
    }

    @Value.Check
    final void checkTimestampColEmpty() {
        if (this.timestampCol() != null && this.timestampCol().isEmpty()) {
            throw new IllegalArgumentException("WindowScale.timestampCol() must not be an empty string");
        }
    }
}

