/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.AsOfJoinRule;
import io.deephaven.api.ColumnName;
import io.deephaven.api.ImmutableAsOfJoinMatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class AsOfJoinMatch {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\A\\s*([a-zA-Z_$][a-zA-Z0-9_$]*)\\s*(>=?|<=?)\\s*([a-zA-Z_$][a-zA-Z0-9_$]*)\\s*\\Z");

    public static AsOfJoinMatch of(ColumnName leftColumn, AsOfJoinRule joinRule, ColumnName rightColumn) {
        return ImmutableAsOfJoinMatch.of(leftColumn, joinRule, rightColumn);
    }

    public static AsOfJoinMatch parseForAj(String x) {
        try {
            ColumnName columnName = ColumnName.parse(x);
            return AsOfJoinMatch.of(columnName, AsOfJoinRule.GREATER_THAN_EQUAL, columnName);
        }
        catch (IllegalArgumentException columnName) {
            AsOfJoinMatch parsed = AsOfJoinMatch.parse(x);
            switch (parsed.joinRule()) {
                case GREATER_THAN: 
                case GREATER_THAN_EQUAL: {
                    return parsed;
                }
            }
            throw new IllegalArgumentException("Unsupported operation for aj: " + (Object)((Object)parsed.joinRule()));
        }
    }

    public static AsOfJoinMatch parseForRaj(String x) {
        try {
            ColumnName columnName = ColumnName.parse(x);
            return AsOfJoinMatch.of(columnName, AsOfJoinRule.LESS_THAN_EQUAL, columnName);
        }
        catch (IllegalArgumentException columnName) {
            AsOfJoinMatch parse = AsOfJoinMatch.parse(x);
            switch (parse.joinRule()) {
                case LESS_THAN: 
                case LESS_THAN_EQUAL: {
                    return parse;
                }
            }
            throw new IllegalArgumentException("Unsupported operation for raj: " + (Object)((Object)parse.joinRule()));
        }
    }

    static AsOfJoinMatch parse(String x) {
        Matcher matcher = EXPRESSION_PATTERN.matcher(x);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Input expression %s does not match expected pattern %s", x, EXPRESSION_PATTERN.pattern()));
        }
        return AsOfJoinMatch.of(ColumnName.of(matcher.group(1)), AsOfJoinRule.parse(matcher.group(2)), ColumnName.of(matcher.group(3)));
    }

    @Value.Parameter
    public abstract ColumnName leftColumn();

    @Value.Parameter
    public abstract AsOfJoinRule joinRule();

    @Value.Parameter
    public abstract ColumnName rightColumn();

    public final String toRpcString() {
        return this.leftColumn().name() + this.joinRule().operatorString() + this.rightColumn().name();
    }

    public final boolean isAj() {
        switch (this.joinRule()) {
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: {
                return true;
            }
        }
        return false;
    }

    public final boolean isRaj() {
        switch (this.joinRule()) {
            case LESS_THAN: 
            case LESS_THAN_EQUAL: {
                return true;
            }
        }
        return false;
    }
}

