/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

public enum AsOfJoinRule {
    LESS_THAN_EQUAL("<="),
    LESS_THAN("<"),
    GREATER_THAN_EQUAL(">="),
    GREATER_THAN(">");

    private final String operatorString;

    public static AsOfJoinRule parse(String x) {
        switch (x) {
            case "<=": {
                return LESS_THAN_EQUAL;
            }
            case "<": {
                return LESS_THAN;
            }
            case ">=": {
                return GREATER_THAN_EQUAL;
            }
            case ">": {
                return GREATER_THAN;
            }
        }
        throw new IllegalArgumentException(String.format("Unable to parse AsOfJoinRule '%s'", x));
    }

    private AsOfJoinRule(String operatorString) {
        this.operatorString = operatorString;
    }

    public String operatorString() {
        return this.operatorString;
    }
}

