/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.api.ColumnName;
import io.deephaven.api.RangeEndRule;
import io.deephaven.api.RangeJoinMatch;
import io.deephaven.api.RangeStartRule;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="RangeJoinMatch", generator="Immutables")
@Immutable
final class ImmutableRangeJoinMatch
extends RangeJoinMatch {
    private final ColumnName leftStartColumn;
    private final RangeStartRule rangeStartRule;
    private final ColumnName rightRangeColumn;
    private final RangeEndRule rangeEndRule;
    private final ColumnName leftEndColumn;

    private ImmutableRangeJoinMatch(Builder builder) {
        this.leftStartColumn = builder.leftStartColumn;
        this.rangeStartRule = builder.rangeStartRule;
        this.rightRangeColumn = builder.rightRangeColumn;
        this.rangeEndRule = builder.rangeEndRule;
        this.leftEndColumn = builder.leftEndColumn;
    }

    @Override
    public ColumnName leftStartColumn() {
        return this.leftStartColumn;
    }

    @Override
    public RangeStartRule rangeStartRule() {
        return this.rangeStartRule;
    }

    @Override
    public ColumnName rightRangeColumn() {
        return this.rightRangeColumn;
    }

    @Override
    public RangeEndRule rangeEndRule() {
        return this.rangeEndRule;
    }

    @Override
    public ColumnName leftEndColumn() {
        return this.leftEndColumn;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRangeJoinMatch && this.equalTo(0, (ImmutableRangeJoinMatch)another);
    }

    private boolean equalTo(int synthetic, ImmutableRangeJoinMatch another) {
        return this.leftStartColumn.equals(another.leftStartColumn) && this.rangeStartRule.equals((Object)another.rangeStartRule) && this.rightRangeColumn.equals(another.rightRangeColumn) && this.rangeEndRule.equals((Object)another.rangeEndRule) && this.leftEndColumn.equals(another.leftEndColumn);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.leftStartColumn.hashCode();
        h += (h << 5) + this.rangeStartRule.hashCode();
        h += (h << 5) + this.rightRangeColumn.hashCode();
        h += (h << 5) + this.rangeEndRule.hashCode();
        h += (h << 5) + this.leftEndColumn.hashCode();
        return h;
    }

    public String toString() {
        return "RangeJoinMatch{leftStartColumn=" + this.leftStartColumn + ", rangeStartRule=" + (Object)((Object)this.rangeStartRule) + ", rightRangeColumn=" + this.rightRangeColumn + ", rangeEndRule=" + (Object)((Object)this.rangeEndRule) + ", leftEndColumn=" + this.leftEndColumn + "}";
    }

    private static ImmutableRangeJoinMatch validate(ImmutableRangeJoinMatch instance) {
        instance.checkLeftColumnsDifferent();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RangeJoinMatch", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements RangeJoinMatch.Builder {
        private static final long INIT_BIT_LEFT_START_COLUMN = 1L;
        private static final long INIT_BIT_RANGE_START_RULE = 2L;
        private static final long INIT_BIT_RIGHT_RANGE_COLUMN = 4L;
        private static final long INIT_BIT_RANGE_END_RULE = 8L;
        private static final long INIT_BIT_LEFT_END_COLUMN = 16L;
        private long initBits = 31L;
        @Nullable
        private ColumnName leftStartColumn;
        @Nullable
        private RangeStartRule rangeStartRule;
        @Nullable
        private ColumnName rightRangeColumn;
        @Nullable
        private RangeEndRule rangeEndRule;
        @Nullable
        private ColumnName leftEndColumn;

        private Builder() {
        }

        @Override
        public final Builder leftStartColumn(ColumnName leftStartColumn) {
            Builder.checkNotIsSet(this.leftStartColumnIsSet(), "leftStartColumn");
            this.leftStartColumn = Objects.requireNonNull(leftStartColumn, "leftStartColumn");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder rangeStartRule(RangeStartRule rangeStartRule) {
            Builder.checkNotIsSet(this.rangeStartRuleIsSet(), "rangeStartRule");
            this.rangeStartRule = Objects.requireNonNull(rangeStartRule, "rangeStartRule");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public final Builder rightRangeColumn(ColumnName rightRangeColumn) {
            Builder.checkNotIsSet(this.rightRangeColumnIsSet(), "rightRangeColumn");
            this.rightRangeColumn = Objects.requireNonNull(rightRangeColumn, "rightRangeColumn");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public final Builder rangeEndRule(RangeEndRule rangeEndRule) {
            Builder.checkNotIsSet(this.rangeEndRuleIsSet(), "rangeEndRule");
            this.rangeEndRule = Objects.requireNonNull(rangeEndRule, "rangeEndRule");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        public final Builder leftEndColumn(ColumnName leftEndColumn) {
            Builder.checkNotIsSet(this.leftEndColumnIsSet(), "leftEndColumn");
            this.leftEndColumn = Objects.requireNonNull(leftEndColumn, "leftEndColumn");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @Override
        public ImmutableRangeJoinMatch build() {
            this.checkRequiredAttributes();
            return ImmutableRangeJoinMatch.validate(new ImmutableRangeJoinMatch(this));
        }

        private boolean leftStartColumnIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean rangeStartRuleIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean rightRangeColumnIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean rangeEndRuleIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean leftEndColumnIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of RangeJoinMatch is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.leftStartColumnIsSet()) {
                attributes.add("leftStartColumn");
            }
            if (!this.rangeStartRuleIsSet()) {
                attributes.add("rangeStartRule");
            }
            if (!this.rightRangeColumnIsSet()) {
                attributes.add("rightRangeColumn");
            }
            if (!this.rangeEndRuleIsSet()) {
                attributes.add("rangeEndRule");
            }
            if (!this.leftEndColumnIsSet()) {
                attributes.add("leftEndColumn");
            }
            return "Cannot build RangeJoinMatch, some of required attributes are not set " + attributes;
        }
    }
}

