/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.api.ColumnName;
import io.deephaven.api.JoinAdditionImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public interface JoinAddition {
    public static JoinAddition of(ColumnName newColumn, ColumnName existingColumn) {
        if (newColumn.equals(existingColumn)) {
            return newColumn;
        }
        return JoinAdditionImpl.of(newColumn, existingColumn);
    }

    public static JoinAddition parse(String x) {
        int ix = x.indexOf(61);
        if (ix < 0) {
            return ColumnName.parse(x);
        }
        ColumnName newColumn = ColumnName.parse(x.substring(0, ix));
        ColumnName existingColumn = ColumnName.parse(x.substring(ix + 1));
        return JoinAddition.of(newColumn, existingColumn);
    }

    public static List<JoinAddition> from(String ... values) {
        return JoinAddition.from(Arrays.asList(values));
    }

    public static List<JoinAddition> from(Collection<String> values) {
        return values.stream().map(JoinAddition::parse).collect(Collectors.toList());
    }

    public ColumnName newColumn();

    public ColumnName existingColumn();
}

