/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.ColumnName;
import io.deephaven.api.ImmutableJoinAdditionImpl;
import io.deephaven.api.JoinAddition;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
abstract class JoinAdditionImpl
implements JoinAddition {
    JoinAdditionImpl() {
    }

    public static JoinAdditionImpl of(ColumnName newColumn, ColumnName existingColumn) {
        return ImmutableJoinAdditionImpl.of(newColumn, existingColumn);
    }

    @Override
    @Value.Parameter
    public abstract ColumnName newColumn();

    @Override
    @Value.Parameter
    public abstract ColumnName existingColumn();

    @Value.Check
    final void checkNotSameColumn() {
        if (this.newColumn().equals(this.existingColumn())) {
            throw new IllegalArgumentException("Should not construct JoinAdditionImpl with equal columns, use the ColumnName directly");
        }
    }
}

