/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.api.ColumnName;
import io.deephaven.api.JoinMatchImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public interface JoinMatch {
    public static Collection<ColumnName> lefts(Collection<? extends JoinMatch> matches) {
        return matches.stream().map(JoinMatch::left).collect(Collectors.toList());
    }

    public static Collection<ColumnName> rights(Collection<? extends JoinMatch> matches) {
        return matches.stream().map(JoinMatch::right).collect(Collectors.toList());
    }

    public static JoinMatch of(ColumnName left, ColumnName right) {
        if (left.equals(right)) {
            return left;
        }
        return JoinMatchImpl.of(left, right);
    }

    public static JoinMatch parse(String x) {
        int ix2;
        int ix = x.indexOf(61);
        if (ix < 0) {
            return ColumnName.parse(x);
        }
        if (ix + 1 == x.length()) {
            throw new IllegalArgumentException(String.format("Unable to parse match '%s', expected form '<left>==<right>' or `<left>=<right>`", x));
        }
        int n = ix2 = x.charAt(ix + 1) == '=' ? ix + 1 : ix;
        if (ix2 + 1 == x.length()) {
            throw new IllegalArgumentException(String.format("Unable to parse match '%s', expected form '<left>==<right>' or `<left>=<right>`", x));
        }
        ColumnName left = ColumnName.parse(x.substring(0, ix));
        ColumnName right = ColumnName.parse(x.substring(ix2 + 1));
        return JoinMatch.of(left, right);
    }

    public static List<JoinMatch> from(String ... values) {
        return JoinMatch.from(Arrays.asList(values));
    }

    public static List<JoinMatch> from(Collection<String> values) {
        return values.stream().map(JoinMatch::parse).collect(Collectors.toList());
    }

    public ColumnName left();

    public ColumnName right();
}

