/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.api.ColumnName;
import io.deephaven.api.PairImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public interface Pair {
    public static Pair of(ColumnName input, ColumnName output) {
        if (input.equals(output)) {
            return input;
        }
        return PairImpl.of(input, output);
    }

    public static Pair parse(String x) {
        int ix = x.indexOf(61);
        if (ix < 0) {
            return ColumnName.parse(x);
        }
        ColumnName output = ColumnName.parse(x.substring(0, ix));
        ColumnName input = ColumnName.parse(x.substring(ix + 1));
        return Pair.of(input, output);
    }

    public static List<Pair> from(String ... values) {
        return Pair.from(Arrays.asList(values));
    }

    public static List<Pair> from(Collection<String> values) {
        return values.stream().map(Pair::parse).collect(Collectors.toList());
    }

    public ColumnName input();

    public ColumnName output();
}

