/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.api.AsOfJoinMatch;
import io.deephaven.api.ColumnName;
import io.deephaven.api.JoinAddition;
import io.deephaven.api.JoinMatch;
import io.deephaven.api.Pair;
import io.deephaven.api.RangeEndRule;
import io.deephaven.api.RangeJoinMatch;
import io.deephaven.api.RangeStartRule;
import io.deephaven.api.RawString;
import io.deephaven.api.Selectable;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.AggregationDescriptions;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.expression.Function;
import io.deephaven.api.expression.Method;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.filter.FilterAnd;
import io.deephaven.api.filter.FilterComparison;
import io.deephaven.api.filter.FilterIn;
import io.deephaven.api.filter.FilterIsNull;
import io.deephaven.api.filter.FilterNot;
import io.deephaven.api.filter.FilterOr;
import io.deephaven.api.filter.FilterPattern;
import io.deephaven.api.literal.Literal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public class Strings {
    public static String of(ColumnName columnName) {
        return columnName.name();
    }

    public static String of(ColumnName columnName, boolean inverted) {
        return (inverted ? "!" : "") + Strings.of(columnName);
    }

    public static String ofColumnNames(Collection<? extends ColumnName> columnNames) {
        return columnNames.stream().map(Strings::of).collect(Collectors.joining(",", "[", "]"));
    }

    public static String of(RawString rawString) {
        return rawString.value();
    }

    public static String of(RawString rawString, boolean invert) {
        return Strings.of(rawString, false, invert);
    }

    private static String of(RawString rawString, boolean encapsulate, boolean invert) {
        String inner = Strings.of(rawString);
        if (invert) {
            return "!" + Strings.encapsulate(inner);
        }
        if (encapsulate) {
            return Strings.encapsulate(inner);
        }
        return inner;
    }

    public static String of(FilterComparison comparison) {
        String lhs = Strings.ofEncapsulated(comparison.lhs());
        String rhs = Strings.ofEncapsulated(comparison.rhs());
        return String.format("%s %s %s", lhs, comparison.operator().javaOperator(), rhs);
    }

    public static String of(FilterIn in) {
        return in.toString();
    }

    private static String of(FilterComparison comparison, boolean encapsulate) {
        String inner = Strings.of(comparison);
        return encapsulate ? Strings.encapsulate(inner) : inner;
    }

    public static String of(FilterIn in, boolean invert) {
        String inner = Strings.of(in);
        return (invert ? "!" : "") + inner;
    }

    public static String of(FilterIsNull isNull) {
        return String.format("isNull(%s)", Strings.of(isNull.expression()));
    }

    public static String of(FilterIsNull isNull, boolean inverted) {
        return (inverted ? "!" : "") + Strings.of(isNull);
    }

    public static String of(FilterOr filterOr) {
        return filterOr.filters().stream().map(Strings::ofEncapsulated).collect(Collectors.joining(" || "));
    }

    private static String of(FilterOr filterOr, boolean encapsulate) {
        String inner = Strings.of(filterOr);
        return encapsulate ? Strings.encapsulate(inner) : inner;
    }

    public static String of(FilterAnd filterAnd) {
        return filterAnd.filters().stream().map(Strings::ofEncapsulated).collect(Collectors.joining(" && "));
    }

    private static String of(FilterAnd filterAnd, boolean encapsulate) {
        String inner = Strings.of(filterAnd);
        return encapsulate ? Strings.encapsulate(inner) : inner;
    }

    public static String of(FilterPattern pattern) {
        return pattern.toString();
    }

    public static String of(FilterPattern pattern, boolean invert) {
        String inner = Strings.of(pattern);
        return (invert ? "!" : "") + inner;
    }

    public static String ofPairs(Collection<? extends Pair> pairs) {
        return pairs.stream().map(Strings::of).collect(Collectors.joining(",", "[", "]"));
    }

    public static String of(Pair pair) {
        if (pair.input().equals(pair.output())) {
            return Strings.of(pair.output());
        }
        return String.format("%s=%s", Strings.of(pair.output()), Strings.of(pair.input()));
    }

    public static String of(JoinMatch match) {
        if (match.left().equals(match.right())) {
            return Strings.of(match.left());
        }
        return String.format("%s==%s", Strings.of(match.left()), Strings.of(match.right()));
    }

    public static String ofJoinMatches(Collection<? extends JoinMatch> matches) {
        return matches.stream().map(Strings::of).collect(Collectors.joining(",", "[", "]"));
    }

    public static String of(JoinAddition addition) {
        if (addition.newColumn().equals(addition.existingColumn())) {
            return Strings.of(addition.newColumn());
        }
        return String.format("%s=%s", Strings.of(addition.newColumn()), Strings.of(addition.existingColumn()));
    }

    public static String ofJoinAdditions(Collection<? extends JoinAddition> additions) {
        return additions.stream().map(Strings::of).collect(Collectors.joining(",", "[", "]"));
    }

    public static String of(AsOfJoinMatch joinMatch) {
        return joinMatch.leftColumn().name() + joinMatch.joinRule().operatorString() + joinMatch.rightColumn().name();
    }

    public static String of(RangeJoinMatch rangeMatch) {
        return String.format("%s%s %s %s %s %s%s", rangeMatch.rangeStartRule() == RangeStartRule.LESS_THAN_OR_EQUAL_ALLOW_PRECEDING ? "<- " : "", rangeMatch.leftStartColumn().name(), rangeMatch.rangeStartRule() == RangeStartRule.LESS_THAN ? "<" : "<=", rangeMatch.rightRangeColumn().name(), rangeMatch.rangeEndRule() == RangeEndRule.GREATER_THAN ? "<" : "<=", rangeMatch.leftEndColumn().name(), rangeMatch.rangeEndRule() == RangeEndRule.GREATER_THAN_OR_EQUAL_ALLOW_FOLLOWING ? " ->" : "");
    }

    public static String of(Aggregation aggregation) {
        return Strings.ofMap(AggregationDescriptions.of(aggregation));
    }

    public static String ofAggregations(Collection<? extends Aggregation> aggregations) {
        return Strings.ofMap(AggregationDescriptions.of(aggregations));
    }

    public static String ofMap(Map<String, String> map) {
        Iterator<Map.Entry<String, String>> entries = map.entrySet().iterator();
        if (!entries.hasNext()) {
            return "[]";
        }
        BiConsumer<StringBuilder, Map.Entry> appender = (sb, e) -> sb.append((String)e.getKey()).append(" = ").append((String)e.getValue());
        StringBuilder sb2 = new StringBuilder();
        appender.accept(sb2.append('['), entries.next());
        while (entries.hasNext()) {
            appender.accept(sb2.append(", "), entries.next());
        }
        return sb2.append(']').toString();
    }

    public static String of(Selectable selectable) {
        String lhs = Strings.of(selectable.newColumn());
        if (selectable.newColumn().equals(selectable.expression())) {
            return lhs;
        }
        return String.format("%s=%s", lhs, Strings.of(selectable.expression()));
    }

    public static String of(Expression expression) {
        return expression.walk(new ExpressionAdapter(false, false));
    }

    public static String of(Filter filter) {
        return Strings.of(filter, false);
    }

    public static String of(FilterNot<?> not) {
        return Strings.of(not.filter(), true);
    }

    public static String of(Filter filter, boolean invert) {
        return filter.walk(new FilterAdapter(false, invert));
    }

    public static String of(Literal value) {
        return value.walk(new LiteralAdapter(false));
    }

    public static String of(Function function) {
        return Strings.of(function, false);
    }

    public static String of(Function function, boolean invert) {
        return (invert ? "!" : "") + function.name() + function.arguments().stream().map(Strings::of).collect(Collectors.joining(", ", "(", ")"));
    }

    public static String of(Method method) {
        return Strings.of(method, false);
    }

    public static String of(Method method, boolean invert) {
        return (invert ? "!" : "") + Strings.of(method.object()) + "." + method.name() + method.arguments().stream().map(Strings::of).collect(Collectors.joining(", ", "(", ")"));
    }

    public static String of(boolean literal) {
        return Boolean.toString(literal);
    }

    public static String of(char literal) {
        return "'" + literal + "'";
    }

    public static String of(byte literal) {
        return "(byte)" + literal;
    }

    public static String of(short literal) {
        return "(short)" + literal;
    }

    public static String of(int literal) {
        return "(int)" + literal;
    }

    public static String of(long literal) {
        return literal + "L";
    }

    public static String of(float literal) {
        return literal + "f";
    }

    public static String of(double literal) {
        return Double.toString(literal);
    }

    public static String of(String literal) {
        return '\"' + StringEscapeUtils.escapeJava((String)literal) + '\"';
    }

    private static String ofEncapsulated(Expression expression) {
        return Strings.ofEncapsulated(expression, false);
    }

    private static String ofEncapsulated(Expression expression, boolean inverted) {
        return expression.walk(new ExpressionAdapter(true, inverted));
    }

    private static String ofEncapsulated(Filter filter) {
        return filter.walk(new FilterAdapter(true, false));
    }

    private static String encapsulate(String x) {
        return "(" + x + ")";
    }

    private static class LiteralAdapter
    implements Literal.Visitor<String> {
        private final boolean inverted;

        public LiteralAdapter(boolean inverted) {
            this.inverted = inverted;
        }

        @Override
        public String visit(boolean literal) {
            return Strings.of(this.inverted ^ literal);
        }

        @Override
        public String visit(char literal) {
            if (this.inverted) {
                throw new IllegalArgumentException();
            }
            return Strings.of(literal);
        }

        @Override
        public String visit(byte literal) {
            if (this.inverted) {
                throw new IllegalArgumentException();
            }
            return Strings.of(literal);
        }

        @Override
        public String visit(short literal) {
            if (this.inverted) {
                throw new IllegalArgumentException();
            }
            return Strings.of(literal);
        }

        @Override
        public String visit(int literal) {
            if (this.inverted) {
                throw new IllegalArgumentException();
            }
            return Strings.of(literal);
        }

        @Override
        public String visit(long literal) {
            if (this.inverted) {
                throw new IllegalArgumentException();
            }
            return Strings.of(literal);
        }

        @Override
        public String visit(float literal) {
            if (this.inverted) {
                throw new IllegalArgumentException();
            }
            return Strings.of(literal);
        }

        @Override
        public String visit(double literal) {
            if (this.inverted) {
                throw new IllegalArgumentException();
            }
            return Strings.of(literal);
        }

        @Override
        public String visit(String literal) {
            if (this.inverted) {
                throw new IllegalArgumentException();
            }
            return Strings.of(literal);
        }
    }

    private static class FilterAdapter
    implements Filter.Visitor<String> {
        private final boolean encapsulate;
        private final boolean invert;

        public FilterAdapter(boolean encapsulate, boolean invert) {
            this.encapsulate = encapsulate;
            this.invert = invert;
        }

        @Override
        public String visit(FilterIsNull isNull) {
            return Strings.of(isNull, this.invert);
        }

        @Override
        public String visit(FilterComparison comparison) {
            return this.invert ? Strings.of(comparison.invert(), this.encapsulate) : Strings.of(comparison, this.encapsulate);
        }

        @Override
        public String visit(FilterIn in) {
            return Strings.of(in, this.invert);
        }

        @Override
        public String visit(FilterNot<?> not) {
            return not.filter().walk(new FilterAdapter(this.encapsulate, !this.invert));
        }

        @Override
        public String visit(FilterOr ors) {
            return this.invert ? Strings.of(ors.invert(), this.encapsulate) : Strings.of(ors, this.encapsulate);
        }

        @Override
        public String visit(FilterAnd ands) {
            return this.invert ? Strings.of(ands.invert(), this.encapsulate) : Strings.of(ands, this.encapsulate);
        }

        @Override
        public String visit(FilterPattern pattern) {
            return Strings.of(pattern, this.invert);
        }

        @Override
        public String visit(Function function) {
            return Strings.of(function, this.invert);
        }

        @Override
        public String visit(Method method) {
            return Strings.of(method, this.invert);
        }

        @Override
        public String visit(boolean literal) {
            return Strings.of(literal ^ this.invert);
        }

        @Override
        public String visit(RawString rawString) {
            return Strings.of(rawString, this.encapsulate, this.invert);
        }
    }

    private static class ExpressionAdapter
    implements Expression.Visitor<String> {
        private final boolean encapsulate;
        private final boolean invert;

        ExpressionAdapter(boolean encapsulate, boolean invert) {
            this.encapsulate = encapsulate;
            this.invert = invert;
        }

        @Override
        public String visit(Filter filter) {
            return filter.walk(new FilterAdapter(this.encapsulate, this.invert));
        }

        @Override
        public String visit(Literal literal) {
            return literal.walk(new LiteralAdapter(this.invert));
        }

        @Override
        public String visit(ColumnName name) {
            return Strings.of(name, this.invert);
        }

        @Override
        public String visit(RawString rawString) {
            return Strings.of(rawString, this.encapsulate, this.invert);
        }

        @Override
        public String visit(Function function) {
            return Strings.of(function, this.invert);
        }

        @Override
        public String visit(Method method) {
            return Strings.of(method, this.invert);
        }
    }
}

