/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg;

import io.deephaven.api.ColumnName;
import io.deephaven.api.Pair;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.Aggregations;
import io.deephaven.api.agg.ColumnAggregation;
import io.deephaven.api.agg.ColumnAggregations;
import io.deephaven.api.agg.Count;
import io.deephaven.api.agg.FirstRowKey;
import io.deephaven.api.agg.LastRowKey;
import io.deephaven.api.agg.Partition;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;

public class AggregationOutputs
implements Aggregation.Visitor {
    protected Stream<ColumnName> out;

    public static Stream<ColumnName> of(Aggregation aggregation) {
        return aggregation.walk(new AggregationOutputs()).getOut();
    }

    public static Stream<ColumnName> of(Collection<? extends Aggregation> aggregations) {
        return aggregations.stream().flatMap(AggregationOutputs::of);
    }

    protected Stream<ColumnName> getOut() {
        return Objects.requireNonNull(this.out);
    }

    @Override
    public void visit(Aggregations aggregations) {
        this.out = aggregations.aggregations().stream().flatMap(AggregationOutputs::of);
    }

    @Override
    public void visit(ColumnAggregation columnAgg) {
        this.out = Stream.of(columnAgg.pair().output());
    }

    @Override
    public void visit(ColumnAggregations columnAggs) {
        this.out = columnAggs.pairs().stream().map(Pair::output);
    }

    @Override
    public void visit(Count count) {
        this.out = Stream.of(count.column());
    }

    @Override
    public void visit(FirstRowKey firstRowKey) {
        this.out = Stream.of(firstRowKey.column());
    }

    @Override
    public void visit(LastRowKey lastRowKey) {
        this.out = Stream.of(lastRowKey.column());
    }

    @Override
    public void visit(Partition partition) {
        this.out = Stream.of(partition.column());
    }
}

