/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.Pair;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.ImmutableColumnAggregations;
import io.deephaven.api.agg.spec.AggSpec;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class ColumnAggregations
implements Aggregation {
    public static Builder builder() {
        return ImmutableColumnAggregations.builder();
    }

    public abstract AggSpec spec();

    public abstract List<Pair> pairs();

    @Override
    public final <V extends Aggregation.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Value.Check
    final void checkSize() {
        if (this.pairs().size() < 2) {
            throw new IllegalArgumentException(String.format("%s should have at least two pairs, has %d", ColumnAggregations.class, this.pairs().size()));
        }
    }

    public static interface Builder {
        public Builder spec(AggSpec var1);

        public Builder addPairs(Pair var1);

        public Builder addPairs(Pair ... var1);

        public Builder addAllPairs(Iterable<? extends Pair> var1);

        public ColumnAggregations build();
    }
}

