/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.agg.spec.AggSpecBase;
import io.deephaven.api.agg.spec.ImmutableAggSpecApproximatePercentile;
import java.util.OptionalDouble;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class AggSpecApproximatePercentile
extends AggSpecBase {
    public static AggSpecApproximatePercentile of(double percentile) {
        return ImmutableAggSpecApproximatePercentile.builder().percentile(percentile).build();
    }

    public static AggSpecApproximatePercentile of(double percentile, double compression) {
        return ImmutableAggSpecApproximatePercentile.builder().percentile(percentile).compression(compression).build();
    }

    @Override
    public final String description() {
        if (this.compression().isPresent()) {
            return String.format("%.2f approximate percentile with compression %.2f", this.percentile(), this.compression().getAsDouble());
        }
        return String.format("%.2f approximate percentile with default compression", this.percentile());
    }

    public abstract double percentile();

    public abstract OptionalDouble compression();

    @Override
    public final <V extends AggSpec.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Value.Check
    final void checkPercentile() {
        if (this.percentile() < 0.0 || this.percentile() > 1.0) {
            throw new IllegalArgumentException("Percentile must be in range [0.0, 1.0]");
        }
    }

    @Value.Check
    final void checkCompression() {
        if (this.compression().isPresent() && this.compression().getAsDouble() < 1.0) {
            throw new IllegalArgumentException("Compression must be greater than or equal to 1.0");
        }
    }
}

