/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.spec;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.agg.spec.AggSpecBase;
import io.deephaven.api.agg.spec.ImmutableAggSpecFormula;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class AggSpecFormula
extends AggSpecBase {
    public static final String PARAM_TOKEN_DEFAULT = "each";

    public static AggSpecFormula of(String formula) {
        return AggSpecFormula.of(formula, PARAM_TOKEN_DEFAULT);
    }

    public static AggSpecFormula of(String formula, String paramToken) {
        return ImmutableAggSpecFormula.of(formula, paramToken);
    }

    @Override
    public final String description() {
        return "formula '" + this.formula() + "' with column param '" + this.paramToken() + '\'';
    }

    @Value.Parameter
    public abstract String formula();

    @Value.Parameter
    public abstract String paramToken();

    @Override
    public final <V extends AggSpec.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Value.Check
    final void checkFormula() {
        if (this.formula().isEmpty()) {
            throw new IllegalArgumentException("formula must not be empty");
        }
    }

    @Value.Check
    final void checkParamToken() {
        if (this.paramToken().isEmpty()) {
            throw new IllegalArgumentException("paramToken must not be empty");
        }
    }
}

