/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.spec;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.agg.spec.AggSpecBase;
import io.deephaven.api.agg.spec.ImmutableAggSpecPercentile;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class AggSpecPercentile
extends AggSpecBase {
    public static final boolean AVERAGE_EVENLY_DIVIDED = false;

    public static AggSpecPercentile of(double percentile) {
        return AggSpecPercentile.of(percentile, false);
    }

    public static AggSpecPercentile of(double percentile, boolean averageEvenlyDivided) {
        return ImmutableAggSpecPercentile.of(percentile, averageEvenlyDivided);
    }

    @Override
    public final String description() {
        return String.format("%.2f percentile%s", this.percentile(), this.averageEvenlyDivided() ? " (averaging when evenly divided)" : "");
    }

    @Value.Parameter
    public abstract double percentile();

    @Value.Parameter
    public abstract boolean averageEvenlyDivided();

    @Override
    public final <V extends AggSpec.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Value.Check
    final void checkPercentile() {
        if (this.percentile() < 0.0 || this.percentile() > 1.0) {
            throw new IllegalArgumentException("Percentile must be in range [0.0, 1.0]");
        }
    }
}

