/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.spec;

import io.deephaven.api.agg.spec.AggSpecApproximatePercentile;
import java.util.ArrayList;
import java.util.Objects;
import java.util.OptionalDouble;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AggSpecApproximatePercentile", generator="Immutables")
@Immutable
final class ImmutableAggSpecApproximatePercentile
extends AggSpecApproximatePercentile {
    private final double percentile;
    @Nullable
    private final Double compression;

    private ImmutableAggSpecApproximatePercentile(Builder builder) {
        this.percentile = builder.percentile;
        this.compression = builder.compression;
    }

    @Override
    public double percentile() {
        return this.percentile;
    }

    @Override
    public OptionalDouble compression() {
        return this.compression != null ? OptionalDouble.of(this.compression) : OptionalDouble.empty();
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAggSpecApproximatePercentile && this.equalTo(0, (ImmutableAggSpecApproximatePercentile)another);
    }

    private boolean equalTo(int synthetic, ImmutableAggSpecApproximatePercentile another) {
        return Double.doubleToLongBits(this.percentile) == Double.doubleToLongBits(another.percentile) && Objects.equals(this.compression, another.compression);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + Double.hashCode(this.percentile);
        h += (h << 5) + Objects.hashCode(this.compression);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AggSpecApproximatePercentile{");
        builder.append("percentile=").append(this.percentile);
        if (this.compression != null) {
            builder.append(", ");
            builder.append("compression=").append(this.compression);
        }
        return builder.append("}").toString();
    }

    private static ImmutableAggSpecApproximatePercentile validate(ImmutableAggSpecApproximatePercentile instance) {
        instance.checkCompression();
        instance.checkPercentile();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AggSpecApproximatePercentile", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PERCENTILE = 1L;
        private static final long OPT_BIT_COMPRESSION = 1L;
        private long initBits = 1L;
        private long optBits;
        private double percentile;
        @Nullable
        private Double compression;

        private Builder() {
        }

        public final Builder percentile(double percentile) {
            Builder.checkNotIsSet(this.percentileIsSet(), "percentile");
            this.percentile = percentile;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder compression(double compression) {
            Builder.checkNotIsSet(this.compressionIsSet(), "compression");
            this.compression = compression;
            this.optBits |= 1L;
            return this;
        }

        public final Builder compression(OptionalDouble compression) {
            Builder.checkNotIsSet(this.compressionIsSet(), "compression");
            this.compression = compression.isPresent() ? Double.valueOf(compression.getAsDouble()) : null;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableAggSpecApproximatePercentile build() {
            this.checkRequiredAttributes();
            return ImmutableAggSpecApproximatePercentile.validate(new ImmutableAggSpecApproximatePercentile(this));
        }

        private boolean compressionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean percentileIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of AggSpecApproximatePercentile is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.percentileIsSet()) {
                attributes.add("percentile");
            }
            return "Cannot build AggSpecApproximatePercentile, some of required attributes are not set " + attributes;
        }
    }
}

