/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.util;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.ColumnName;
import io.deephaven.api.agg.util.ImmutablePercentileOutput;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class PercentileOutput {
    public static PercentileOutput of(double percentile, ColumnName output) {
        return ImmutablePercentileOutput.of(percentile, output);
    }

    public static PercentileOutput of(double percentile, String output) {
        return PercentileOutput.of(percentile, ColumnName.of(output));
    }

    @Value.Parameter
    public abstract double percentile();

    @Value.Parameter
    public abstract ColumnName output();

    @Value.Check
    final void checkPercentile() {
        if (this.percentile() < 0.0 || this.percentile() > 1.0) {
            throw new IllegalArgumentException("Percentile must be in range [0.0, 1.0]");
        }
    }
}

