/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.expression;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.expression.ImmutableFunction;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.filter.FilterNot;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class Function
implements Expression,
Filter {
    public static Builder builder() {
        return ImmutableFunction.builder();
    }

    public static Function of(String name, Expression ... arguments) {
        return Function.builder().name(name).addArguments(arguments).build();
    }

    public static Function of(String name, List<? extends Expression> arguments) {
        return Function.builder().name(name).addAllArguments(arguments).build();
    }

    public abstract String name();

    public abstract List<Expression> arguments();

    @Override
    public final FilterNot<Function> invert() {
        return Filter.not(this);
    }

    @Override
    public final <T> T walk(Expression.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public final <T> T walk(Filter.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder addArguments(Expression var1);

        public Builder addArguments(Expression ... var1);

        public Builder addAllArguments(Iterable<? extends Expression> var1);

        public Function build();
    }
}

