/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.expression;

import io.deephaven.api.expression.Expression;
import io.deephaven.api.expression.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Method", generator="Immutables")
@Immutable
final class ImmutableMethod
extends Method {
    private final Expression object;
    private final String name;
    private final List<Expression> arguments;

    private ImmutableMethod(Builder builder) {
        this.object = builder.object;
        this.name = builder.name;
        this.arguments = ImmutableMethod.createUnmodifiableList(true, builder.arguments);
    }

    @Override
    public Expression object() {
        return this.object;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<Expression> arguments() {
        return this.arguments;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMethod && this.equalTo(0, (ImmutableMethod)another);
    }

    private boolean equalTo(int synthetic, ImmutableMethod another) {
        return this.object.equals(another.object) && this.name.equals(another.name) && this.arguments.equals(another.arguments);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.object.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.arguments.hashCode();
        return h;
    }

    public String toString() {
        return "Method{object=" + this.object + ", name=" + this.name + ", arguments=" + this.arguments + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Method", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements Method.Builder {
        private static final long INIT_BIT_OBJECT = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private Expression object;
        @Nullable
        private String name;
        private final List<Expression> arguments = new ArrayList<Expression>();

        private Builder() {
        }

        @Override
        public final Builder object(Expression object) {
            Builder.checkNotIsSet(this.objectIsSet(), "object");
            this.object = Objects.requireNonNull(object, "object");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder name(String name) {
            Builder.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public final Builder addArguments(Expression element) {
            this.arguments.add(Objects.requireNonNull(element, "arguments element"));
            return this;
        }

        @Override
        public final Builder addArguments(Expression ... elements) {
            for (Expression element : elements) {
                this.arguments.add(Objects.requireNonNull(element, "arguments element"));
            }
            return this;
        }

        @Override
        public final Builder addAllArguments(Iterable<? extends Expression> elements) {
            for (Expression expression : elements) {
                this.arguments.add(Objects.requireNonNull(expression, "arguments element"));
            }
            return this;
        }

        @Override
        public ImmutableMethod build() {
            this.checkRequiredAttributes();
            return new ImmutableMethod(this);
        }

        private boolean objectIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Method is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.objectIsSet()) {
                attributes.add("object");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            return "Cannot build Method, some of required attributes are not set " + attributes;
        }
    }
}

