/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.expression;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.expression.ImmutableMethod;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.filter.FilterNot;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class Method
implements Expression,
Filter {
    public static Builder builder() {
        return ImmutableMethod.builder();
    }

    public static Method of(Expression object, String name, Expression ... arguments) {
        return Method.builder().object(object).name(name).addArguments(arguments).build();
    }

    public static Method of(Expression object, String name, List<? extends Expression> arguments) {
        return Method.builder().object(object).name(name).addAllArguments(arguments).build();
    }

    public abstract Expression object();

    public abstract String name();

    public abstract List<Expression> arguments();

    @Override
    public final FilterNot<Method> invert() {
        return Filter.not(this);
    }

    @Override
    public final <T> T walk(Expression.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public final <T> T walk(Filter.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public static interface Builder {
        public Builder object(Expression var1);

        public Builder name(String var1);

        public Builder addArguments(Expression var1);

        public Builder addArguments(Expression ... var1);

        public Builder addAllArguments(Iterable<? extends Expression> var1);

        public Method build();
    }
}

