/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.filter;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.ColumnName;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.filter.FilterBase;
import io.deephaven.api.filter.ImmutableFilterComparison;
import java.util.Objects;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class FilterComparison
extends FilterBase {
    public static Builder builder() {
        return ImmutableFilterComparison.builder();
    }

    public static FilterComparison lt(Expression lhs, Expression rhs) {
        return Operator.LESS_THAN.of(lhs, rhs);
    }

    public static FilterComparison leq(Expression lhs, Expression rhs) {
        return Operator.LESS_THAN_OR_EQUAL.of(lhs, rhs);
    }

    public static FilterComparison gt(Expression lhs, Expression rhs) {
        return Operator.GREATER_THAN.of(lhs, rhs);
    }

    public static FilterComparison geq(Expression lhs, Expression rhs) {
        return Operator.GREATER_THAN_OR_EQUAL.of(lhs, rhs);
    }

    public static FilterComparison eq(Expression lhs, Expression rhs) {
        return Operator.EQUALS.of(lhs, rhs);
    }

    public static FilterComparison neq(Expression lhs, Expression rhs) {
        return Operator.NOT_EQUALS.of(lhs, rhs);
    }

    public abstract Operator operator();

    public abstract Expression lhs();

    public abstract Expression rhs();

    public final FilterComparison transpose() {
        return this.operator().transpose().of(this.rhs(), this.lhs());
    }

    public final FilterComparison maybeTranspose() {
        if (this.lhs() instanceof ColumnName) {
            return this;
        }
        if (this.rhs() instanceof ColumnName) {
            return this.transpose();
        }
        return this;
    }

    @Override
    public final FilterComparison invert() {
        return this.operator().invert().of(this.lhs(), this.rhs());
    }

    @Override
    public final <T> T walk(Filter.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public static interface Builder {
        public Builder operator(Operator var1);

        public Builder lhs(Expression var1);

        public Builder rhs(Expression var1);

        public FilterComparison build();
    }

    public static enum Operator {
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        EQUALS("=="),
        NOT_EQUALS("!=");

        private final String javaOperator;

        private Operator(String javaOperator) {
            this.javaOperator = Objects.requireNonNull(javaOperator);
        }

        public String javaOperator() {
            return this.javaOperator;
        }

        public FilterComparison of(Expression lhs, Expression rhs) {
            return FilterComparison.builder().operator(this).lhs(lhs).rhs(rhs).build();
        }

        public Operator invert() {
            switch (this) {
                case LESS_THAN: {
                    return GREATER_THAN_OR_EQUAL;
                }
                case LESS_THAN_OR_EQUAL: {
                    return GREATER_THAN;
                }
                case GREATER_THAN: {
                    return LESS_THAN_OR_EQUAL;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return LESS_THAN;
                }
                case EQUALS: {
                    return NOT_EQUALS;
                }
                case NOT_EQUALS: {
                    return EQUALS;
                }
            }
            throw new IllegalStateException("Unexpected operator " + (Object)((Object)this));
        }

        public Operator transpose() {
            switch (this) {
                case LESS_THAN: {
                    return GREATER_THAN;
                }
                case LESS_THAN_OR_EQUAL: {
                    return GREATER_THAN_OR_EQUAL;
                }
                case GREATER_THAN: {
                    return LESS_THAN;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return LESS_THAN_OR_EQUAL;
                }
                case EQUALS: {
                    return EQUALS;
                }
                case NOT_EQUALS: {
                    return NOT_EQUALS;
                }
            }
            throw new IllegalStateException("Unexpected operator " + (Object)((Object)this));
        }
    }
}

