/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.literal;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.literal.ImmutableLiteralLong;
import io.deephaven.api.literal.Literal;
import io.deephaven.api.literal.LiteralBase;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
abstract class LiteralLong
extends LiteralBase {
    LiteralLong() {
    }

    public static LiteralLong of(long value) {
        return ImmutableLiteralLong.of(value);
    }

    @Value.Parameter
    public abstract long value();

    @Override
    public final <T> T walk(Literal.Visitor<T> visitor) {
        return visitor.visit(this.value());
    }

    @Value.Check
    final void checkNotDeephavenNull() {
        if (this.value() == Long.MIN_VALUE) {
            throw new IllegalArgumentException("Can't represent QueryConstants.NULL_LONG, is Deephaven null representation");
        }
    }
}

