/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.object;

import io.deephaven.api.object.UnionObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

abstract class UnionObjectBase
implements UnionObject {
    private static final Set<Class<?>> BOXED_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class)));

    UnionObjectBase() {
    }

    static boolean isBoxedPrimitive(Class<?> clazz) {
        return BOXED_TYPES.contains(clazz);
    }

    @Override
    public final Object unwrap() {
        return this.visit(Unwrap.INSTANCE);
    }

    @Override
    public final Number number() {
        return this.expect(Number.class);
    }

    @Override
    public final boolean booleanValue() {
        return this.expect(Boolean.class);
    }

    @Override
    public final char charValue() {
        return this.expect(Character.class).charValue();
    }

    @Override
    public final byte byteValue() {
        return this.number().byteValue();
    }

    @Override
    public final short shortValue() {
        return this.number().shortValue();
    }

    @Override
    public final int intValue() {
        return this.number().intValue();
    }

    @Override
    public final long longValue() {
        return this.number().longValue();
    }

    @Override
    public final float floatValue() {
        return this.number().floatValue();
    }

    @Override
    public final double doubleValue() {
        return this.number().doubleValue();
    }

    @Override
    public final <T> T expect(Class<T> clazz) {
        return this.visit(new Expect<T>(clazz));
    }

    private static class Expect<T>
    implements UnionObject.Visitor<T> {
        private final Class<T> clazz;

        public Expect(Class<T> clazz) {
            this.clazz = Objects.requireNonNull(clazz);
        }

        @Override
        public T visit(boolean x) {
            if (!this.clazz.isInstance(x)) {
                throw new IllegalArgumentException(String.format("boolean is not %s", this.clazz));
            }
            return this.clazz.cast(x);
        }

        @Override
        public T visit(char x) {
            if (!this.clazz.isInstance(Character.valueOf(x))) {
                throw new IllegalArgumentException(String.format("char is not %s", this.clazz));
            }
            return this.clazz.cast(Character.valueOf(x));
        }

        @Override
        public T visit(byte x) {
            if (!this.clazz.isInstance(x)) {
                throw new IllegalArgumentException(String.format("byte is not %s", this.clazz));
            }
            return this.clazz.cast(x);
        }

        @Override
        public T visit(short x) {
            if (!this.clazz.isInstance(x)) {
                throw new IllegalArgumentException(String.format("short is not %s", this.clazz));
            }
            return this.clazz.cast(x);
        }

        @Override
        public T visit(int x) {
            if (!this.clazz.isInstance(x)) {
                throw new IllegalArgumentException(String.format("int is not %s", this.clazz));
            }
            return this.clazz.cast(x);
        }

        @Override
        public T visit(long x) {
            if (!this.clazz.isInstance(x)) {
                throw new IllegalArgumentException(String.format("long is not %s", this.clazz));
            }
            return this.clazz.cast(x);
        }

        @Override
        public T visit(float x) {
            if (!this.clazz.isInstance(Float.valueOf(x))) {
                throw new IllegalArgumentException(String.format("float is not %s", this.clazz));
            }
            return this.clazz.cast(Float.valueOf(x));
        }

        @Override
        public T visit(double x) {
            if (!this.clazz.isInstance(x)) {
                throw new IllegalArgumentException(String.format("double is not %s", this.clazz));
            }
            return this.clazz.cast(x);
        }

        @Override
        public T visit(Object x) {
            if (!this.clazz.isInstance(x)) {
                throw new IllegalArgumentException(String.format("Object %s is not %s", x.getClass(), this.clazz));
            }
            return this.clazz.cast(x);
        }
    }

    static enum Unwrap implements UnionObject.Visitor<Object>
    {
        INSTANCE;


        @Override
        public Object visit(boolean x) {
            return x;
        }

        @Override
        public Object visit(char x) {
            return Character.valueOf(x);
        }

        @Override
        public Object visit(byte x) {
            return x;
        }

        @Override
        public Object visit(short x) {
            return x;
        }

        @Override
        public Object visit(int x) {
            return x;
        }

        @Override
        public Object visit(long x) {
            return x;
        }

        @Override
        public Object visit(float x) {
            return Float.valueOf(x);
        }

        @Override
        public Object visit(double x) {
            return x;
        }

        @Override
        public Object visit(Object x) {
            return x;
        }
    }
}

