/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.snapshot;

import io.deephaven.api.JoinAddition;
import io.deephaven.api.snapshot.SnapshotWhenOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SnapshotWhenOptions", generator="Immutables")
@Immutable
final class ImmutableSnapshotWhenOptions
extends SnapshotWhenOptions {
    private final Set<SnapshotWhenOptions.Flag> flags;
    private final List<JoinAddition> stampColumns;

    private ImmutableSnapshotWhenOptions(Builder builder) {
        this.flags = ImmutableSnapshotWhenOptions.createUnmodifiableEnumSet(builder.flags);
        this.stampColumns = ImmutableSnapshotWhenOptions.createUnmodifiableList(true, builder.stampColumns);
    }

    @Override
    public Set<SnapshotWhenOptions.Flag> flags() {
        return this.flags;
    }

    @Override
    public List<JoinAddition> stampColumns() {
        return this.stampColumns;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSnapshotWhenOptions && this.equalTo(0, (ImmutableSnapshotWhenOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableSnapshotWhenOptions another) {
        return this.flags.equals(another.flags) && this.stampColumns.equals(another.stampColumns);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.stampColumns.hashCode();
        return h;
    }

    public String toString() {
        return "SnapshotWhenOptions{flags=" + this.flags + ", stampColumns=" + this.stampColumns + "}";
    }

    private static ImmutableSnapshotWhenOptions validate(ImmutableSnapshotWhenOptions instance) {
        instance.checkHistory();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        List<T> list = ImmutableSnapshotWhenOptions.createSafeList(iterable, true, false);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton((Enum)list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    @Generated(from="SnapshotWhenOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements SnapshotWhenOptions.Builder {
        private final EnumSet<SnapshotWhenOptions.Flag> flags = EnumSet.noneOf(SnapshotWhenOptions.Flag.class);
        private final List<JoinAddition> stampColumns = new ArrayList<JoinAddition>();

        private Builder() {
        }

        @Override
        public final Builder addFlags(SnapshotWhenOptions.Flag element) {
            this.flags.add(Objects.requireNonNull(element, "flags element"));
            return this;
        }

        @Override
        public final Builder addFlags(SnapshotWhenOptions.Flag ... elements) {
            for (SnapshotWhenOptions.Flag element : elements) {
                this.flags.add(Objects.requireNonNull(element, "flags element"));
            }
            return this;
        }

        @Override
        public final Builder addAllFlags(Iterable<SnapshotWhenOptions.Flag> elements) {
            for (SnapshotWhenOptions.Flag element : elements) {
                this.flags.add(Objects.requireNonNull(element, "flags element"));
            }
            return this;
        }

        @Override
        public final Builder addStampColumns(JoinAddition element) {
            this.stampColumns.add(Objects.requireNonNull(element, "stampColumns element"));
            return this;
        }

        @Override
        public final Builder addStampColumns(JoinAddition ... elements) {
            for (JoinAddition element : elements) {
                this.stampColumns.add(Objects.requireNonNull(element, "stampColumns element"));
            }
            return this;
        }

        @Override
        public final Builder addAllStampColumns(Iterable<? extends JoinAddition> elements) {
            for (JoinAddition joinAddition : elements) {
                this.stampColumns.add(Objects.requireNonNull(joinAddition, "stampColumns element"));
            }
            return this;
        }

        @Override
        public ImmutableSnapshotWhenOptions build() {
            return ImmutableSnapshotWhenOptions.validate(new ImmutableSnapshotWhenOptions(this));
        }
    }
}

