/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.snapshot;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.JoinAddition;
import io.deephaven.api.Strings;
import io.deephaven.api.snapshot.ImmutableSnapshotWhenOptions;
import java.util.List;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class SnapshotWhenOptions {
    public static Builder builder() {
        return ImmutableSnapshotWhenOptions.builder();
    }

    public static SnapshotWhenOptions of(Flag ... flags) {
        return SnapshotWhenOptions.builder().addFlags(flags).build();
    }

    public static SnapshotWhenOptions of(boolean initial, boolean incremental, boolean history, String ... stampColumns) {
        Builder builder = SnapshotWhenOptions.builder();
        if (initial) {
            builder.addFlags(Flag.INITIAL);
        }
        if (incremental) {
            builder.addFlags(Flag.INCREMENTAL);
        }
        if (history) {
            builder.addFlags(Flag.HISTORY);
        }
        for (String stampColumn : stampColumns) {
            builder.addStampColumns(JoinAddition.parse(stampColumn));
        }
        return builder.build();
    }

    public static SnapshotWhenOptions of(Iterable<Flag> flags, String ... stampColumns) {
        Builder builder = SnapshotWhenOptions.builder().addAllFlags(flags);
        for (String stampColumn : stampColumns) {
            builder.addStampColumns(JoinAddition.parse(stampColumn));
        }
        return builder.build();
    }

    public abstract Set<Flag> flags();

    public abstract List<JoinAddition> stampColumns();

    public final boolean has(Flag flag) {
        return this.flags().contains((Object)flag);
    }

    public final String description() {
        return String.format("initial=%b,incremental=%b,history=%b,stampColumns=%s", this.has(Flag.INITIAL), this.has(Flag.INCREMENTAL), this.has(Flag.HISTORY), Strings.ofJoinAdditions(this.stampColumns()));
    }

    @Value.Check
    final void checkHistory() {
        if (this.has(Flag.HISTORY) && (this.has(Flag.INCREMENTAL) || this.has(Flag.INITIAL))) {
            throw new UnsupportedOperationException("snapshotWhen with history does not currently support incremental nor initial. See https://github.com/deephaven/deephaven-core/issues/3260.");
        }
    }

    public static interface Builder {
        public Builder addStampColumns(JoinAddition var1);

        public Builder addStampColumns(JoinAddition ... var1);

        public Builder addAllStampColumns(Iterable<? extends JoinAddition> var1);

        public Builder addFlags(Flag var1);

        public Builder addFlags(Flag ... var1);

        public Builder addAllFlags(Iterable<Flag> var1);

        public SnapshotWhenOptions build();
    }

    public static enum Flag {
        INITIAL,
        INCREMENTAL,
        HISTORY;

    }
}

