/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby;

import io.deephaven.api.Pair;
import io.deephaven.api.updateby.ColumnUpdateOperation;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ColumnUpdateOperation", generator="Immutables")
@Immutable
final class ImmutableColumnUpdateOperation
extends ColumnUpdateOperation {
    private final UpdateBySpec spec;
    private final List<Pair> columns;

    private ImmutableColumnUpdateOperation(Builder builder) {
        this.spec = builder.spec;
        this.columns = ImmutableColumnUpdateOperation.createUnmodifiableList(true, builder.columns);
    }

    @Override
    public UpdateBySpec spec() {
        return this.spec;
    }

    @Override
    public List<Pair> columns() {
        return this.columns;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableColumnUpdateOperation && this.equalTo(0, (ImmutableColumnUpdateOperation)another);
    }

    private boolean equalTo(int synthetic, ImmutableColumnUpdateOperation another) {
        return this.spec.equals(another.spec) && this.columns.equals(another.columns);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.spec.hashCode();
        h += (h << 5) + this.columns.hashCode();
        return h;
    }

    public String toString() {
        return "ColumnUpdateOperation{spec=" + this.spec + ", columns=" + this.columns + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ColumnUpdateOperation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ColumnUpdateOperation.Builder {
        private static final long INIT_BIT_SPEC = 1L;
        private long initBits = 1L;
        @Nullable
        private UpdateBySpec spec;
        private final List<Pair> columns = new ArrayList<Pair>();

        private Builder() {
        }

        @Override
        public final Builder spec(UpdateBySpec spec) {
            Builder.checkNotIsSet(this.specIsSet(), "spec");
            this.spec = Objects.requireNonNull(spec, "spec");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder addColumns(Pair element) {
            this.columns.add(Objects.requireNonNull(element, "columns element"));
            return this;
        }

        @Override
        public final Builder addColumns(Pair ... elements) {
            for (Pair element : elements) {
                this.columns.add(Objects.requireNonNull(element, "columns element"));
            }
            return this;
        }

        @Override
        public final Builder addAllColumns(Iterable<? extends Pair> elements) {
            for (Pair pair : elements) {
                this.columns.add(Objects.requireNonNull(pair, "columns element"));
            }
            return this;
        }

        @Override
        public ImmutableColumnUpdateOperation build() {
            this.checkRequiredAttributes();
            return new ImmutableColumnUpdateOperation(this);
        }

        private boolean specIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ColumnUpdateOperation is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.specIsSet()) {
                attributes.add("spec");
            }
            return "Cannot build ColumnUpdateOperation, some of required attributes are not set " + attributes;
        }
    }
}

