/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby;

import io.deephaven.api.updateby.BadDataBehavior;
import io.deephaven.api.updateby.OperationControl;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="OperationControl", generator="Immutables")
@Immutable
final class ImmutableOperationControl
extends OperationControl {
    @Nullable
    private final BadDataBehavior onNullValue;
    @Nullable
    private final BadDataBehavior onNanValue;
    @Nullable
    private final BadDataBehavior onNullTime;
    @Nullable
    private final BadDataBehavior onNegativeDeltaTime;
    @Nullable
    private final BadDataBehavior onZeroDeltaTime;
    @Nullable
    private final MathContext bigValueContext;
    private final transient BadDataBehavior onNullValueOrDefault;
    private final transient BadDataBehavior onNanValueOrDefault;
    private final transient MathContext bigValueContextOrDefault;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOperationControl(Builder builder) {
        this.onNullValue = builder.onNullValue;
        this.onNanValue = builder.onNanValue;
        this.onNullTime = builder.onNullTime;
        this.onNegativeDeltaTime = builder.onNegativeDeltaTime;
        this.onZeroDeltaTime = builder.onZeroDeltaTime;
        this.bigValueContext = builder.bigValueContext;
        this.onNullValueOrDefault = this.initShim.onNullValueOrDefault();
        this.onNanValueOrDefault = this.initShim.onNanValueOrDefault();
        this.bigValueContextOrDefault = this.initShim.bigValueContextOrDefault();
        this.initShim = null;
    }

    @Override
    public Optional<BadDataBehavior> onNullValue() {
        return Optional.ofNullable(this.onNullValue);
    }

    @Override
    public Optional<BadDataBehavior> onNanValue() {
        return Optional.ofNullable(this.onNanValue);
    }

    @Override
    public Optional<BadDataBehavior> onNullTime() {
        return Optional.ofNullable(this.onNullTime);
    }

    @Override
    public Optional<BadDataBehavior> onNegativeDeltaTime() {
        return Optional.ofNullable(this.onNegativeDeltaTime);
    }

    @Override
    public Optional<BadDataBehavior> onZeroDeltaTime() {
        return Optional.ofNullable(this.onZeroDeltaTime);
    }

    @Override
    public Optional<MathContext> bigValueContext() {
        return Optional.ofNullable(this.bigValueContext);
    }

    @Override
    public BadDataBehavior onNullValueOrDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.onNullValueOrDefault() : this.onNullValueOrDefault;
    }

    @Override
    public BadDataBehavior onNanValueOrDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.onNanValueOrDefault() : this.onNanValueOrDefault;
    }

    @Override
    public MathContext bigValueContextOrDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bigValueContextOrDefault() : this.bigValueContextOrDefault;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOperationControl && this.equalTo(0, (ImmutableOperationControl)another);
    }

    private boolean equalTo(int synthetic, ImmutableOperationControl another) {
        return Objects.equals((Object)this.onNullValue, (Object)another.onNullValue) && Objects.equals((Object)this.onNanValue, (Object)another.onNanValue) && Objects.equals((Object)this.onNullTime, (Object)another.onNullTime) && Objects.equals((Object)this.onNegativeDeltaTime, (Object)another.onNegativeDeltaTime) && Objects.equals((Object)this.onZeroDeltaTime, (Object)another.onZeroDeltaTime) && Objects.equals(this.bigValueContext, another.bigValueContext) && this.onNullValueOrDefault.equals((Object)another.onNullValueOrDefault) && this.onNanValueOrDefault.equals((Object)another.onNanValueOrDefault) && this.bigValueContextOrDefault.equals(another.bigValueContextOrDefault);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.onNullValue);
        h += (h << 5) + Objects.hashCode((Object)this.onNanValue);
        h += (h << 5) + Objects.hashCode((Object)this.onNullTime);
        h += (h << 5) + Objects.hashCode((Object)this.onNegativeDeltaTime);
        h += (h << 5) + Objects.hashCode((Object)this.onZeroDeltaTime);
        h += (h << 5) + Objects.hashCode(this.bigValueContext);
        h += (h << 5) + this.onNullValueOrDefault.hashCode();
        h += (h << 5) + this.onNanValueOrDefault.hashCode();
        h += (h << 5) + this.bigValueContextOrDefault.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OperationControl{");
        if (this.onNullValue != null) {
            builder.append("onNullValue=").append((Object)this.onNullValue);
        }
        if (this.onNanValue != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("onNanValue=").append((Object)this.onNanValue);
        }
        if (this.onNullTime != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("onNullTime=").append((Object)this.onNullTime);
        }
        if (this.onNegativeDeltaTime != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("onNegativeDeltaTime=").append((Object)this.onNegativeDeltaTime);
        }
        if (this.onZeroDeltaTime != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("onZeroDeltaTime=").append((Object)this.onZeroDeltaTime);
        }
        if (this.bigValueContext != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("bigValueContext=").append(this.bigValueContext);
        }
        if (builder.length() > 17) {
            builder.append(", ");
        }
        builder.append("onNullValueOrDefault=").append((Object)this.onNullValueOrDefault);
        builder.append(", ");
        builder.append("onNanValueOrDefault=").append((Object)this.onNanValueOrDefault);
        builder.append(", ");
        builder.append("bigValueContextOrDefault=").append(this.bigValueContextOrDefault);
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OperationControl", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements OperationControl.Builder {
        private static final long OPT_BIT_ON_NULL_VALUE = 1L;
        private static final long OPT_BIT_ON_NAN_VALUE = 2L;
        private static final long OPT_BIT_ON_NULL_TIME = 4L;
        private static final long OPT_BIT_ON_NEGATIVE_DELTA_TIME = 8L;
        private static final long OPT_BIT_ON_ZERO_DELTA_TIME = 16L;
        private static final long OPT_BIT_BIG_VALUE_CONTEXT = 32L;
        private long optBits;
        @Nullable
        private BadDataBehavior onNullValue;
        @Nullable
        private BadDataBehavior onNanValue;
        @Nullable
        private BadDataBehavior onNullTime;
        @Nullable
        private BadDataBehavior onNegativeDeltaTime;
        @Nullable
        private BadDataBehavior onZeroDeltaTime;
        @Nullable
        private MathContext bigValueContext;

        private Builder() {
        }

        @Override
        public final Builder onNullValue(BadDataBehavior onNullValue) {
            Builder.checkNotIsSet(this.onNullValueIsSet(), "onNullValue");
            this.onNullValue = Objects.requireNonNull(onNullValue, "onNullValue");
            this.optBits |= 1L;
            return this;
        }

        public final Builder onNullValue(Optional<? extends BadDataBehavior> onNullValue) {
            Builder.checkNotIsSet(this.onNullValueIsSet(), "onNullValue");
            this.onNullValue = onNullValue.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        @Override
        public final Builder onNanValue(BadDataBehavior onNanValue) {
            Builder.checkNotIsSet(this.onNanValueIsSet(), "onNanValue");
            this.onNanValue = Objects.requireNonNull(onNanValue, "onNanValue");
            this.optBits |= 2L;
            return this;
        }

        public final Builder onNanValue(Optional<? extends BadDataBehavior> onNanValue) {
            Builder.checkNotIsSet(this.onNanValueIsSet(), "onNanValue");
            this.onNanValue = onNanValue.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        public final Builder onNullTime(BadDataBehavior onNullTime) {
            Builder.checkNotIsSet(this.onNullTimeIsSet(), "onNullTime");
            this.onNullTime = Objects.requireNonNull(onNullTime, "onNullTime");
            this.optBits |= 4L;
            return this;
        }

        public final Builder onNullTime(Optional<? extends BadDataBehavior> onNullTime) {
            Builder.checkNotIsSet(this.onNullTimeIsSet(), "onNullTime");
            this.onNullTime = onNullTime.orElse(null);
            this.optBits |= 4L;
            return this;
        }

        public final Builder onNegativeDeltaTime(BadDataBehavior onNegativeDeltaTime) {
            Builder.checkNotIsSet(this.onNegativeDeltaTimeIsSet(), "onNegativeDeltaTime");
            this.onNegativeDeltaTime = Objects.requireNonNull(onNegativeDeltaTime, "onNegativeDeltaTime");
            this.optBits |= 8L;
            return this;
        }

        public final Builder onNegativeDeltaTime(Optional<? extends BadDataBehavior> onNegativeDeltaTime) {
            Builder.checkNotIsSet(this.onNegativeDeltaTimeIsSet(), "onNegativeDeltaTime");
            this.onNegativeDeltaTime = onNegativeDeltaTime.orElse(null);
            this.optBits |= 8L;
            return this;
        }

        public final Builder onZeroDeltaTime(BadDataBehavior onZeroDeltaTime) {
            Builder.checkNotIsSet(this.onZeroDeltaTimeIsSet(), "onZeroDeltaTime");
            this.onZeroDeltaTime = Objects.requireNonNull(onZeroDeltaTime, "onZeroDeltaTime");
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder onZeroDeltaTime(Optional<? extends BadDataBehavior> onZeroDeltaTime) {
            Builder.checkNotIsSet(this.onZeroDeltaTimeIsSet(), "onZeroDeltaTime");
            this.onZeroDeltaTime = onZeroDeltaTime.orElse(null);
            this.optBits |= 0x10L;
            return this;
        }

        @Override
        public final Builder bigValueContext(MathContext bigValueContext) {
            Builder.checkNotIsSet(this.bigValueContextIsSet(), "bigValueContext");
            this.bigValueContext = Objects.requireNonNull(bigValueContext, "bigValueContext");
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder bigValueContext(Optional<? extends MathContext> bigValueContext) {
            Builder.checkNotIsSet(this.bigValueContextIsSet(), "bigValueContext");
            this.bigValueContext = bigValueContext.orElse(null);
            this.optBits |= 0x20L;
            return this;
        }

        @Override
        public ImmutableOperationControl build() {
            return new ImmutableOperationControl(this);
        }

        private boolean onNullValueIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean onNanValueIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean onNullTimeIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean onNegativeDeltaTimeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean onZeroDeltaTimeIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean bigValueContextIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of OperationControl is strict, attribute is already set: ".concat(name));
            }
        }
    }

    @Generated(from="OperationControl", generator="Immutables")
    private final class InitShim {
        private byte onNullValueOrDefaultBuildStage = 0;
        private BadDataBehavior onNullValueOrDefault;
        private byte onNanValueOrDefaultBuildStage = 0;
        private BadDataBehavior onNanValueOrDefault;
        private byte bigValueContextOrDefaultBuildStage = 0;
        private MathContext bigValueContextOrDefault;

        private InitShim() {
        }

        BadDataBehavior onNullValueOrDefault() {
            if (this.onNullValueOrDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.onNullValueOrDefaultBuildStage == 0) {
                this.onNullValueOrDefaultBuildStage = (byte)-1;
                this.onNullValueOrDefault = Objects.requireNonNull(ImmutableOperationControl.super.onNullValueOrDefault(), "onNullValueOrDefault");
                this.onNullValueOrDefaultBuildStage = 1;
            }
            return this.onNullValueOrDefault;
        }

        BadDataBehavior onNanValueOrDefault() {
            if (this.onNanValueOrDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.onNanValueOrDefaultBuildStage == 0) {
                this.onNanValueOrDefaultBuildStage = (byte)-1;
                this.onNanValueOrDefault = Objects.requireNonNull(ImmutableOperationControl.super.onNanValueOrDefault(), "onNanValueOrDefault");
                this.onNanValueOrDefaultBuildStage = 1;
            }
            return this.onNanValueOrDefault;
        }

        MathContext bigValueContextOrDefault() {
            if (this.bigValueContextOrDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bigValueContextOrDefaultBuildStage == 0) {
                this.bigValueContextOrDefaultBuildStage = (byte)-1;
                this.bigValueContextOrDefault = Objects.requireNonNull(ImmutableOperationControl.super.bigValueContextOrDefault(), "bigValueContextOrDefault");
                this.bigValueContextOrDefaultBuildStage = 1;
            }
            return this.bigValueContextOrDefault;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.onNullValueOrDefaultBuildStage == -1) {
                attributes.add("onNullValueOrDefault");
            }
            if (this.onNanValueOrDefaultBuildStage == -1) {
                attributes.add("onNanValueOrDefault");
            }
            if (this.bigValueContextOrDefaultBuildStage == -1) {
                attributes.add("bigValueContextOrDefault");
            }
            return "Cannot build OperationControl, attribute initializers form cycle " + attributes;
        }
    }
}

