/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.BadDataBehavior;
import io.deephaven.api.updateby.ImmutableOperationControl;
import java.math.MathContext;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class OperationControl {
    public static Builder builder() {
        return ImmutableOperationControl.builder();
    }

    public static OperationControl defaultInstance() {
        return OperationControl.builder().build();
    }

    public abstract Optional<BadDataBehavior> onNullValue();

    public abstract Optional<BadDataBehavior> onNanValue();

    public abstract Optional<BadDataBehavior> onNullTime();

    public abstract Optional<BadDataBehavior> onNegativeDeltaTime();

    public abstract Optional<BadDataBehavior> onZeroDeltaTime();

    public abstract Optional<MathContext> bigValueContext();

    @Value.Derived
    public BadDataBehavior onNullValueOrDefault() {
        return this.onNullValue().orElse(BadDataBehavior.SKIP);
    }

    @Value.Derived
    public BadDataBehavior onNanValueOrDefault() {
        return this.onNanValue().orElse(BadDataBehavior.SKIP);
    }

    @Value.Derived
    public MathContext bigValueContextOrDefault() {
        return this.bigValueContext().orElse(MathContext.DECIMAL128);
    }

    public final OperationControl materialize() {
        return OperationControl.builder().onNullValue(this.onNullValueOrDefault()).onNanValue(this.onNanValueOrDefault()).bigValueContext(this.bigValueContextOrDefault()).build();
    }

    public static interface Builder {
        public Builder onNullValue(BadDataBehavior var1);

        public Builder onNanValue(BadDataBehavior var1);

        public Builder bigValueContext(MathContext var1);

        public OperationControl build();
    }
}

