/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby;

import io.deephaven.api.Pair;
import io.deephaven.api.updateby.ColumnUpdateOperation;
import io.deephaven.api.updateby.DeltaControl;
import io.deephaven.api.updateby.OperationControl;
import io.deephaven.api.updateby.spec.CumMinMaxSpec;
import io.deephaven.api.updateby.spec.CumProdSpec;
import io.deephaven.api.updateby.spec.CumSumSpec;
import io.deephaven.api.updateby.spec.DeltaSpec;
import io.deephaven.api.updateby.spec.EmMinMaxSpec;
import io.deephaven.api.updateby.spec.EmStdSpec;
import io.deephaven.api.updateby.spec.EmaSpec;
import io.deephaven.api.updateby.spec.EmsSpec;
import io.deephaven.api.updateby.spec.FillBySpec;
import io.deephaven.api.updateby.spec.RollingAvgSpec;
import io.deephaven.api.updateby.spec.RollingCountSpec;
import io.deephaven.api.updateby.spec.RollingFormulaSpec;
import io.deephaven.api.updateby.spec.RollingGroupSpec;
import io.deephaven.api.updateby.spec.RollingMinMaxSpec;
import io.deephaven.api.updateby.spec.RollingProductSpec;
import io.deephaven.api.updateby.spec.RollingStdSpec;
import io.deephaven.api.updateby.spec.RollingSumSpec;
import io.deephaven.api.updateby.spec.RollingWAvgSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import java.time.Duration;

public interface UpdateByOperation {
    public static ColumnUpdateOperation of(UpdateBySpec spec, String ... columns) {
        return spec.clause(columns);
    }

    public static ColumnUpdateOperation of(UpdateBySpec spec, Pair ... columns) {
        return spec.clause(columns);
    }

    public static UpdateByOperation CumSum(String ... pairs) {
        return CumSumSpec.of().clause(pairs);
    }

    public static UpdateByOperation CumProd(String ... pairs) {
        return CumProdSpec.of().clause(pairs);
    }

    public static UpdateByOperation CumMin(String ... pairs) {
        return CumMinMaxSpec.of(false).clause(pairs);
    }

    public static UpdateByOperation CumMax(String ... pairs) {
        return CumMinMaxSpec.of(true).clause(pairs);
    }

    public static UpdateByOperation Fill(String ... pairs) {
        return FillBySpec.of().clause(pairs);
    }

    public static UpdateByOperation Ema(double tickDecay, String ... pairs) {
        return EmaSpec.ofTicks(tickDecay).clause(pairs);
    }

    public static UpdateByOperation Ema(OperationControl control, double tickDecay, String ... pairs) {
        return EmaSpec.ofTicks(control, tickDecay).clause(pairs);
    }

    public static UpdateByOperation Ema(String timestampColumn, long timeDecay, String ... pairs) {
        return EmaSpec.ofTime(timestampColumn, timeDecay).clause(pairs);
    }

    public static UpdateByOperation Ema(OperationControl control, String timestampColumn, long timeDecay, String ... pairs) {
        return EmaSpec.ofTime(control, timestampColumn, timeDecay).clause(pairs);
    }

    public static UpdateByOperation Ema(String timestampColumn, Duration durationDecay, String ... pairs) {
        return EmaSpec.ofTime(timestampColumn, durationDecay).clause(pairs);
    }

    public static UpdateByOperation Ema(OperationControl control, String timestampColumn, Duration durationDecay, String ... pairs) {
        return EmaSpec.ofTime(control, timestampColumn, durationDecay).clause(pairs);
    }

    public static UpdateByOperation Ems(double tickDecay, String ... pairs) {
        return EmsSpec.ofTicks(tickDecay).clause(pairs);
    }

    public static UpdateByOperation Ems(OperationControl control, double tickDecay, String ... pairs) {
        return EmsSpec.ofTicks(control, tickDecay).clause(pairs);
    }

    public static UpdateByOperation Ems(String timestampColumn, long timeDecay, String ... pairs) {
        return EmsSpec.ofTime(timestampColumn, timeDecay).clause(pairs);
    }

    public static UpdateByOperation Ems(OperationControl control, String timestampColumn, long timeDecay, String ... pairs) {
        return EmsSpec.ofTime(control, timestampColumn, timeDecay).clause(pairs);
    }

    public static UpdateByOperation Ems(String timestampColumn, Duration durationDecay, String ... pairs) {
        return EmsSpec.ofTime(timestampColumn, durationDecay).clause(pairs);
    }

    public static UpdateByOperation Ems(OperationControl control, String timestampColumn, Duration durationDecay, String ... pairs) {
        return EmsSpec.ofTime(control, timestampColumn, durationDecay).clause(pairs);
    }

    public static UpdateByOperation EmMin(double tickDecay, String ... pairs) {
        return EmMinMaxSpec.ofTicks(false, tickDecay).clause(pairs);
    }

    public static UpdateByOperation EmMin(OperationControl control, double tickDecay, String ... pairs) {
        return EmMinMaxSpec.ofTicks(control, false, tickDecay).clause(pairs);
    }

    public static UpdateByOperation EmMin(String timestampColumn, long timeDecay, String ... pairs) {
        return EmMinMaxSpec.ofTime(false, timestampColumn, timeDecay).clause(pairs);
    }

    public static UpdateByOperation EmMin(OperationControl control, String timestampColumn, long timeDecay, String ... pairs) {
        return EmMinMaxSpec.ofTime(control, false, timestampColumn, timeDecay).clause(pairs);
    }

    public static UpdateByOperation EmMin(String timestampColumn, Duration durationDecay, String ... pairs) {
        return EmMinMaxSpec.ofTime(false, timestampColumn, durationDecay).clause(pairs);
    }

    public static UpdateByOperation EmMin(OperationControl control, String timestampColumn, Duration durationDecay, String ... pairs) {
        return EmMinMaxSpec.ofTime(control, false, timestampColumn, durationDecay).clause(pairs);
    }

    public static UpdateByOperation EmMax(double tickDecay, String ... pairs) {
        return EmMinMaxSpec.ofTicks(true, tickDecay).clause(pairs);
    }

    public static UpdateByOperation EmMax(OperationControl control, double tickDecay, String ... pairs) {
        return EmMinMaxSpec.ofTicks(control, true, tickDecay).clause(pairs);
    }

    public static UpdateByOperation EmMax(String timestampColumn, long timeDecay, String ... pairs) {
        return EmMinMaxSpec.ofTime(true, timestampColumn, timeDecay).clause(pairs);
    }

    public static UpdateByOperation EmMax(OperationControl control, String timestampColumn, long timeDecay, String ... pairs) {
        return EmMinMaxSpec.ofTime(control, true, timestampColumn, timeDecay).clause(pairs);
    }

    public static UpdateByOperation EmMax(String timestampColumn, Duration durationDecay, String ... pairs) {
        return EmMinMaxSpec.ofTime(true, timestampColumn, durationDecay).clause(pairs);
    }

    public static UpdateByOperation EmMax(OperationControl control, String timestampColumn, Duration durationDecay, String ... pairs) {
        return EmMinMaxSpec.ofTime(control, true, timestampColumn, durationDecay).clause(pairs);
    }

    public static UpdateByOperation EmStd(double tickDecay, String ... pairs) {
        return EmStdSpec.ofTicks(tickDecay).clause(pairs);
    }

    public static UpdateByOperation EmStd(OperationControl control, double tickDecay, String ... pairs) {
        return EmStdSpec.ofTicks(control, tickDecay).clause(pairs);
    }

    public static UpdateByOperation EmStd(String timestampColumn, long timeDecay, String ... pairs) {
        return EmStdSpec.ofTime(timestampColumn, timeDecay).clause(pairs);
    }

    public static UpdateByOperation EmStd(OperationControl control, String timestampColumn, long timeDecay, String ... pairs) {
        return EmStdSpec.ofTime(control, timestampColumn, timeDecay).clause(pairs);
    }

    public static UpdateByOperation EmStd(String timestampColumn, Duration durationDecay, String ... pairs) {
        return EmStdSpec.ofTime(timestampColumn, durationDecay).clause(pairs);
    }

    public static UpdateByOperation EmStd(OperationControl control, String timestampColumn, Duration durationDecay, String ... pairs) {
        return EmStdSpec.ofTime(control, timestampColumn, durationDecay).clause(pairs);
    }

    public static UpdateByOperation Delta(String ... pairs) {
        return DeltaSpec.of().clause(pairs);
    }

    public static UpdateByOperation Delta(DeltaControl control, String ... pairs) {
        return DeltaSpec.of(control).clause(pairs);
    }

    public static UpdateByOperation RollingSum(long revTicks, String ... pairs) {
        return RollingSumSpec.ofTicks(revTicks).clause(pairs);
    }

    public static UpdateByOperation RollingSum(long revTicks, long fwdTicks, String ... pairs) {
        return RollingSumSpec.ofTicks(revTicks, fwdTicks).clause(pairs);
    }

    public static UpdateByOperation RollingSum(String timestampCol, Duration revDuration, String ... pairs) {
        return RollingSumSpec.ofTime(timestampCol, revDuration).clause(pairs);
    }

    public static UpdateByOperation RollingSum(String timestampCol, Duration revDuration, Duration fwdDuration, String ... pairs) {
        return RollingSumSpec.ofTime(timestampCol, revDuration, fwdDuration).clause(pairs);
    }

    public static UpdateByOperation RollingSum(String timestampCol, long revTime, String ... pairs) {
        return RollingSumSpec.ofTime(timestampCol, revTime).clause(pairs);
    }

    public static UpdateByOperation RollingSum(String timestampCol, long revTime, long fwdTime, String ... pairs) {
        return RollingSumSpec.ofTime(timestampCol, revTime, fwdTime).clause(pairs);
    }

    public static UpdateByOperation RollingGroup(long prevTimeTicks, String ... pairs) {
        return RollingGroupSpec.ofTicks(prevTimeTicks).clause(pairs);
    }

    public static UpdateByOperation RollingGroup(long prevTimeTicks, long fwdTimeTicks, String ... pairs) {
        return RollingGroupSpec.ofTicks(prevTimeTicks, fwdTimeTicks).clause(pairs);
    }

    public static UpdateByOperation RollingGroup(String timestampCol, Duration prevWindowDuration, String ... pairs) {
        return RollingGroupSpec.ofTime(timestampCol, prevWindowDuration).clause(pairs);
    }

    public static UpdateByOperation RollingGroup(String timestampCol, Duration prevWindowDuration, Duration fwdWindowDuration, String ... pairs) {
        return RollingGroupSpec.ofTime(timestampCol, prevWindowDuration, fwdWindowDuration).clause(pairs);
    }

    public static UpdateByOperation RollingGroup(String timestampCol, long prevWindowNanos, String ... pairs) {
        return RollingGroupSpec.ofTime(timestampCol, prevWindowNanos).clause(pairs);
    }

    public static UpdateByOperation RollingGroup(String timestampCol, long prevWindowNanos, long fwdWindowNanos, String ... pairs) {
        return RollingGroupSpec.ofTime(timestampCol, prevWindowNanos, fwdWindowNanos).clause(pairs);
    }

    public static UpdateByOperation RollingAvg(long revTicks, String ... pairs) {
        return RollingAvgSpec.ofTicks(revTicks).clause(pairs);
    }

    public static UpdateByOperation RollingAvg(long revTicks, long fwdTicks, String ... pairs) {
        return RollingAvgSpec.ofTicks(revTicks, fwdTicks).clause(pairs);
    }

    public static UpdateByOperation RollingAvg(String timestampCol, Duration revDuration, String ... pairs) {
        return RollingAvgSpec.ofTime(timestampCol, revDuration).clause(pairs);
    }

    public static UpdateByOperation RollingAvg(String timestampCol, Duration revDuration, Duration fwdDuration, String ... pairs) {
        return RollingAvgSpec.ofTime(timestampCol, revDuration, fwdDuration).clause(pairs);
    }

    public static UpdateByOperation RollingAvg(String timestampCol, long revTime, String ... pairs) {
        return RollingAvgSpec.ofTime(timestampCol, revTime).clause(pairs);
    }

    public static UpdateByOperation RollingAvg(String timestampCol, long revTime, long fwdTime, String ... pairs) {
        return RollingAvgSpec.ofTime(timestampCol, revTime, fwdTime).clause(pairs);
    }

    public static UpdateByOperation RollingMin(long revTicks, String ... pairs) {
        return RollingMinMaxSpec.ofTicks(false, revTicks).clause(pairs);
    }

    public static UpdateByOperation RollingMin(long revTicks, long fwdTicks, String ... pairs) {
        return RollingMinMaxSpec.ofTicks(false, revTicks, fwdTicks).clause(pairs);
    }

    public static UpdateByOperation RollingMin(String timestampCol, Duration revDuration, String ... pairs) {
        return RollingMinMaxSpec.ofTime(false, timestampCol, revDuration).clause(pairs);
    }

    public static UpdateByOperation RollingMin(String timestampCol, Duration revDuration, Duration fwdDuration, String ... pairs) {
        return RollingMinMaxSpec.ofTime(false, timestampCol, revDuration, fwdDuration).clause(pairs);
    }

    public static UpdateByOperation RollingMin(String timestampCol, long revTime, String ... pairs) {
        return RollingMinMaxSpec.ofTime(false, timestampCol, revTime).clause(pairs);
    }

    public static UpdateByOperation RollingMin(String timestampCol, long revTime, long fwdTime, String ... pairs) {
        return RollingMinMaxSpec.ofTime(false, timestampCol, revTime, fwdTime).clause(pairs);
    }

    public static UpdateByOperation RollingMax(long revTicks, String ... pairs) {
        return RollingMinMaxSpec.ofTicks(true, revTicks).clause(pairs);
    }

    public static UpdateByOperation RollingMax(long revTicks, long fwdTicks, String ... pairs) {
        return RollingMinMaxSpec.ofTicks(true, revTicks, fwdTicks).clause(pairs);
    }

    public static UpdateByOperation RollingMax(String timestampCol, Duration revDuration, String ... pairs) {
        return RollingMinMaxSpec.ofTime(true, timestampCol, revDuration).clause(pairs);
    }

    public static UpdateByOperation RollingMax(String timestampCol, Duration revDuration, Duration fwdDuration, String ... pairs) {
        return RollingMinMaxSpec.ofTime(true, timestampCol, revDuration, fwdDuration).clause(pairs);
    }

    public static UpdateByOperation RollingMax(String timestampCol, long revTime, String ... pairs) {
        return RollingMinMaxSpec.ofTime(true, timestampCol, revTime).clause(pairs);
    }

    public static UpdateByOperation RollingMax(String timestampCol, long revTime, long fwdTime, String ... pairs) {
        return RollingMinMaxSpec.ofTime(true, timestampCol, revTime, fwdTime).clause(pairs);
    }

    public static UpdateByOperation RollingProduct(long revTicks, long fwdTicks, String ... pairs) {
        return RollingProductSpec.ofTicks(revTicks, fwdTicks).clause(pairs);
    }

    public static UpdateByOperation RollingProduct(String timestampCol, Duration revDuration, String ... pairs) {
        return RollingProductSpec.ofTime(timestampCol, revDuration).clause(pairs);
    }

    public static UpdateByOperation RollingProduct(String timestampCol, Duration revDuration, Duration fwdDuration, String ... pairs) {
        return RollingProductSpec.ofTime(timestampCol, revDuration, fwdDuration).clause(pairs);
    }

    public static UpdateByOperation RollingProduct(String timestampCol, long revTime, String ... pairs) {
        return RollingProductSpec.ofTime(timestampCol, revTime).clause(pairs);
    }

    public static UpdateByOperation RollingProduct(String timestampCol, long revTime, long fwdTime, String ... pairs) {
        return RollingProductSpec.ofTime(timestampCol, revTime, fwdTime).clause(pairs);
    }

    public static UpdateByOperation RollingCount(long revTicks, String ... pairs) {
        return RollingCountSpec.ofTicks(revTicks).clause(pairs);
    }

    public static UpdateByOperation RollingCount(long revTicks, long fwdTicks, String ... pairs) {
        return RollingCountSpec.ofTicks(revTicks, fwdTicks).clause(pairs);
    }

    public static UpdateByOperation RollingCount(String timestampCol, Duration revDuration, String ... pairs) {
        return RollingCountSpec.ofTime(timestampCol, revDuration).clause(pairs);
    }

    public static UpdateByOperation RollingCount(String timestampCol, Duration revDuration, Duration fwdDuration, String ... pairs) {
        return RollingCountSpec.ofTime(timestampCol, revDuration, fwdDuration).clause(pairs);
    }

    public static UpdateByOperation RollingCount(String timestampCol, long revTime, String ... pairs) {
        return RollingCountSpec.ofTime(timestampCol, revTime).clause(pairs);
    }

    public static UpdateByOperation RollingCount(String timestampCol, long revTime, long fwdTime, String ... pairs) {
        return RollingCountSpec.ofTime(timestampCol, revTime, fwdTime).clause(pairs);
    }

    public static UpdateByOperation RollingStd(long revTicks, String ... pairs) {
        return RollingStdSpec.ofTicks(revTicks).clause(pairs);
    }

    public static UpdateByOperation RollingStd(long revTicks, long fwdTicks, String ... pairs) {
        return RollingStdSpec.ofTicks(revTicks, fwdTicks).clause(pairs);
    }

    public static UpdateByOperation RollingStd(String timestampCol, Duration revDuration, String ... pairs) {
        return RollingStdSpec.ofTime(timestampCol, revDuration).clause(pairs);
    }

    public static UpdateByOperation RollingStd(String timestampCol, Duration revDuration, Duration fwdDuration, String ... pairs) {
        return RollingStdSpec.ofTime(timestampCol, revDuration, fwdDuration).clause(pairs);
    }

    public static UpdateByOperation RollingStd(String timestampCol, long revTime, String ... pairs) {
        return RollingStdSpec.ofTime(timestampCol, revTime).clause(pairs);
    }

    public static UpdateByOperation RollingStd(String timestampCol, long revTime, long fwdTime, String ... pairs) {
        return RollingStdSpec.ofTime(timestampCol, revTime, fwdTime).clause(pairs);
    }

    public static UpdateByOperation RollingWAvg(long revTicks, String weightCol, String ... pairs) {
        return RollingWAvgSpec.ofTicks(revTicks, weightCol).clause(pairs);
    }

    public static UpdateByOperation RollingWAvg(long revTicks, long fwdTicks, String weightCol, String ... pairs) {
        return RollingWAvgSpec.ofTicks(revTicks, fwdTicks, weightCol).clause(pairs);
    }

    public static UpdateByOperation RollingWAvg(String timestampCol, Duration revDuration, String weightCol, String ... pairs) {
        return RollingWAvgSpec.ofTime(timestampCol, revDuration, weightCol).clause(pairs);
    }

    public static UpdateByOperation RollingWAvg(String timestampCol, Duration revDuration, Duration fwdDuration, String weightCol, String ... pairs) {
        return RollingWAvgSpec.ofTime(timestampCol, revDuration, fwdDuration, weightCol).clause(pairs);
    }

    public static UpdateByOperation RollingWAvg(String timestampCol, long revTime, String weightCol, String ... pairs) {
        return RollingWAvgSpec.ofTime(timestampCol, revTime, weightCol).clause(pairs);
    }

    public static UpdateByOperation RollingWAvg(String timestampCol, long revTime, long fwdTime, String weightCol, String ... pairs) {
        return RollingWAvgSpec.ofTime(timestampCol, revTime, fwdTime, weightCol).clause(pairs);
    }

    public static UpdateByOperation RollingFormula(long revTicks, String formula, String paramToken, String ... pairs) {
        return RollingFormulaSpec.ofTicks(revTicks, formula, paramToken).clause(pairs);
    }

    public static UpdateByOperation RollingFormula(long revTicks, long fwdTicks, String formula, String paramToken, String ... pairs) {
        return RollingFormulaSpec.ofTicks(revTicks, fwdTicks, formula, paramToken).clause(pairs);
    }

    public static UpdateByOperation RollingFormula(String timestampCol, Duration revDuration, String formula, String paramToken, String ... pairs) {
        return RollingFormulaSpec.ofTime(timestampCol, revDuration, formula, paramToken).clause(pairs);
    }

    public static UpdateByOperation RollingFormula(String timestampCol, Duration revDuration, Duration fwdDuration, String formula, String paramToken, String ... pairs) {
        return RollingFormulaSpec.ofTime(timestampCol, revDuration, fwdDuration, formula, paramToken).clause(pairs);
    }

    public static UpdateByOperation RollingFormula(String timestampCol, long revTime, String formula, String paramToken, String ... pairs) {
        return RollingFormulaSpec.ofTime(timestampCol, revTime, formula, paramToken).clause(pairs);
    }

    public static UpdateByOperation RollingFormula(String timestampCol, long revTime, long fwdTime, String formula, String paramToken, String ... pairs) {
        return RollingFormulaSpec.ofTime(timestampCol, revTime, fwdTime, formula, paramToken).clause(pairs);
    }

    public <T> T walk(Visitor<T> var1);

    public static interface Visitor<T> {
        public T visit(ColumnUpdateOperation var1);
    }
}

