/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.OperationControl;
import io.deephaven.api.updateby.spec.ImmutableEmMinMaxSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.UpdateBySpecBase;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class EmMinMaxSpec
extends UpdateBySpecBase {
    public static EmMinMaxSpec of(OperationControl control, boolean isMax, WindowScale windowScale) {
        return ImmutableEmMinMaxSpec.builder().control(control).isMax(isMax).windowScale(windowScale).build();
    }

    public static EmMinMaxSpec of(boolean isMax, WindowScale windowScale) {
        return ImmutableEmMinMaxSpec.builder().isMax(isMax).windowScale(windowScale).build();
    }

    public static EmMinMaxSpec ofTime(OperationControl control, boolean isMax, String timestampCol, long timeScaleNanos) {
        return EmMinMaxSpec.of(control, isMax, WindowScale.ofTime(timestampCol, timeScaleNanos));
    }

    public static EmMinMaxSpec ofTime(boolean isMax, String timestampCol, long timeScaleNanos) {
        return EmMinMaxSpec.of(isMax, WindowScale.ofTime(timestampCol, timeScaleNanos));
    }

    public static EmMinMaxSpec ofTime(OperationControl control, boolean isMax, String timestampCol, Duration emaDuration) {
        return EmMinMaxSpec.of(control, isMax, WindowScale.ofTime(timestampCol, emaDuration));
    }

    public static EmMinMaxSpec ofTime(boolean isMax, String timestampCol, Duration emaDuration) {
        return EmMinMaxSpec.of(isMax, WindowScale.ofTime(timestampCol, emaDuration));
    }

    public static EmMinMaxSpec ofTicks(OperationControl control, boolean isMax, double tickWindow) {
        return EmMinMaxSpec.of(control, isMax, WindowScale.ofTicks(tickWindow));
    }

    public static EmMinMaxSpec ofTicks(boolean isMax, double tickWindow) {
        return EmMinMaxSpec.of(isMax, WindowScale.ofTicks(tickWindow));
    }

    @Value.Parameter
    public abstract boolean isMax();

    public abstract Optional<OperationControl> control();

    @Value.Parameter
    public abstract WindowScale windowScale();

    public final OperationControl controlOrDefault() {
        return this.control().orElseGet(OperationControl::defaultInstance);
    }

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return EmMinMaxSpec.applicableToNumeric(inputType) || inputType == Character.TYPE || inputType == Character.class;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

