/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.OperationControl;
import io.deephaven.api.updateby.spec.ImmutableEmaSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.UpdateBySpecBase;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class EmaSpec
extends UpdateBySpecBase {
    public static EmaSpec of(OperationControl control, WindowScale windowScale) {
        return ImmutableEmaSpec.builder().control(control).windowScale(windowScale).build();
    }

    public static EmaSpec of(WindowScale windowScale) {
        return ImmutableEmaSpec.builder().windowScale(windowScale).build();
    }

    public static EmaSpec ofTime(OperationControl control, String timestampCol, long timeScaleNanos) {
        return EmaSpec.of(control, WindowScale.ofTime(timestampCol, timeScaleNanos));
    }

    public static EmaSpec ofTime(String timestampCol, long timeScaleNanos) {
        return EmaSpec.of(WindowScale.ofTime(timestampCol, timeScaleNanos));
    }

    public static EmaSpec ofTime(OperationControl control, String timestampCol, Duration emaDuration) {
        return EmaSpec.of(control, WindowScale.ofTime(timestampCol, emaDuration));
    }

    public static EmaSpec ofTime(String timestampCol, Duration emaDuration) {
        return EmaSpec.of(WindowScale.ofTime(timestampCol, emaDuration));
    }

    public static EmaSpec ofTicks(OperationControl control, double tickWindow) {
        return EmaSpec.of(control, WindowScale.ofTicks(tickWindow));
    }

    public static EmaSpec ofTicks(double tickWindow) {
        return EmaSpec.of(WindowScale.ofTicks(tickWindow));
    }

    public abstract Optional<OperationControl> control();

    public abstract WindowScale windowScale();

    public final OperationControl controlOrDefault() {
        return this.control().orElseGet(OperationControl::defaultInstance);
    }

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return EmaSpec.applicableToNumeric(inputType) || inputType == Character.TYPE || inputType == Character.class;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

