/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.api.updateby.OperationControl;
import io.deephaven.api.updateby.spec.EmMinMaxSpec;
import io.deephaven.api.updateby.spec.WindowScale;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="EmMinMaxSpec", generator="Immutables")
@Immutable
final class ImmutableEmMinMaxSpec
extends EmMinMaxSpec {
    private final boolean isMax;
    @Nullable
    private final OperationControl control;
    private final WindowScale windowScale;

    private ImmutableEmMinMaxSpec(boolean isMax, WindowScale windowScale) {
        this.isMax = isMax;
        this.windowScale = Objects.requireNonNull(windowScale, "windowScale");
        this.control = null;
    }

    private ImmutableEmMinMaxSpec(Builder builder) {
        this.isMax = builder.isMax;
        this.control = builder.control;
        this.windowScale = builder.windowScale;
    }

    @Override
    public boolean isMax() {
        return this.isMax;
    }

    @Override
    public Optional<OperationControl> control() {
        return Optional.ofNullable(this.control);
    }

    @Override
    public WindowScale windowScale() {
        return this.windowScale;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEmMinMaxSpec && this.equalTo(0, (ImmutableEmMinMaxSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableEmMinMaxSpec another) {
        return this.isMax == another.isMax && Objects.equals(this.control, another.control) && this.windowScale.equals(another.windowScale);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + Boolean.hashCode(this.isMax);
        h += (h << 5) + Objects.hashCode(this.control);
        h += (h << 5) + this.windowScale.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("EmMinMaxSpec{");
        builder.append("isMax=").append(this.isMax);
        if (this.control != null) {
            builder.append(", ");
            builder.append("control=").append(this.control);
        }
        builder.append(", ");
        builder.append("windowScale=").append(this.windowScale);
        return builder.append("}").toString();
    }

    public static ImmutableEmMinMaxSpec of(boolean isMax, WindowScale windowScale) {
        return new ImmutableEmMinMaxSpec(isMax, windowScale);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EmMinMaxSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IS_MAX = 1L;
        private static final long INIT_BIT_WINDOW_SCALE = 2L;
        private static final long OPT_BIT_CONTROL = 1L;
        private long initBits = 3L;
        private long optBits;
        private boolean isMax;
        @Nullable
        private OperationControl control;
        @Nullable
        private WindowScale windowScale;

        private Builder() {
        }

        public final Builder isMax(boolean isMax) {
            Builder.checkNotIsSet(this.isMaxIsSet(), "isMax");
            this.isMax = isMax;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder control(OperationControl control) {
            Builder.checkNotIsSet(this.controlIsSet(), "control");
            this.control = Objects.requireNonNull(control, "control");
            this.optBits |= 1L;
            return this;
        }

        public final Builder control(Optional<? extends OperationControl> control) {
            Builder.checkNotIsSet(this.controlIsSet(), "control");
            this.control = control.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        public final Builder windowScale(WindowScale windowScale) {
            Builder.checkNotIsSet(this.windowScaleIsSet(), "windowScale");
            this.windowScale = Objects.requireNonNull(windowScale, "windowScale");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEmMinMaxSpec build() {
            this.checkRequiredAttributes();
            return new ImmutableEmMinMaxSpec(this);
        }

        private boolean controlIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean isMaxIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean windowScaleIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of EmMinMaxSpec is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.isMaxIsSet()) {
                attributes.add("isMax");
            }
            if (!this.windowScaleIsSet()) {
                attributes.add("windowScale");
            }
            return "Cannot build EmMinMaxSpec, some of required attributes are not set " + attributes;
        }
    }
}

