/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.api.updateby.spec.RollingGroupSpec;
import io.deephaven.api.updateby.spec.WindowScale;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="RollingGroupSpec", generator="Immutables")
@Immutable
final class ImmutableRollingGroupSpec
extends RollingGroupSpec {
    private final WindowScale revWindowScale;
    private final WindowScale fwdWindowScale;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRollingGroupSpec(Builder builder) {
        if (builder.revWindowScaleIsSet()) {
            this.initShim.revWindowScale(builder.revWindowScale);
        }
        if (builder.fwdWindowScaleIsSet()) {
            this.initShim.fwdWindowScale(builder.fwdWindowScale);
        }
        this.revWindowScale = this.initShim.revWindowScale();
        this.fwdWindowScale = this.initShim.fwdWindowScale();
        this.initShim = null;
    }

    @Override
    public WindowScale revWindowScale() {
        InitShim shim = this.initShim;
        return shim != null ? shim.revWindowScale() : this.revWindowScale;
    }

    @Override
    public WindowScale fwdWindowScale() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fwdWindowScale() : this.fwdWindowScale;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRollingGroupSpec && this.equalTo(0, (ImmutableRollingGroupSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableRollingGroupSpec another) {
        return this.revWindowScale.equals(another.revWindowScale) && this.fwdWindowScale.equals(another.fwdWindowScale);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.revWindowScale.hashCode();
        h += (h << 5) + this.fwdWindowScale.hashCode();
        return h;
    }

    public String toString() {
        return "RollingGroupSpec{revWindowScale=" + this.revWindowScale + ", fwdWindowScale=" + this.fwdWindowScale + "}";
    }

    private static ImmutableRollingGroupSpec validate(ImmutableRollingGroupSpec instance) {
        instance.checkWindowSizes();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RollingGroupSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_REV_WINDOW_SCALE = 1L;
        private static final long OPT_BIT_FWD_WINDOW_SCALE = 2L;
        private long optBits;
        @Nullable
        private WindowScale revWindowScale;
        @Nullable
        private WindowScale fwdWindowScale;

        private Builder() {
        }

        public final Builder revWindowScale(WindowScale revWindowScale) {
            Builder.checkNotIsSet(this.revWindowScaleIsSet(), "revWindowScale");
            this.revWindowScale = Objects.requireNonNull(revWindowScale, "revWindowScale");
            this.optBits |= 1L;
            return this;
        }

        public final Builder fwdWindowScale(WindowScale fwdWindowScale) {
            Builder.checkNotIsSet(this.fwdWindowScaleIsSet(), "fwdWindowScale");
            this.fwdWindowScale = Objects.requireNonNull(fwdWindowScale, "fwdWindowScale");
            this.optBits |= 2L;
            return this;
        }

        public ImmutableRollingGroupSpec build() {
            return ImmutableRollingGroupSpec.validate(new ImmutableRollingGroupSpec(this));
        }

        private boolean revWindowScaleIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean fwdWindowScaleIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of RollingGroupSpec is strict, attribute is already set: ".concat(name));
            }
        }
    }

    @Generated(from="RollingGroupSpec", generator="Immutables")
    private final class InitShim {
        private byte revWindowScaleBuildStage = 0;
        private WindowScale revWindowScale;
        private byte fwdWindowScaleBuildStage = 0;
        private WindowScale fwdWindowScale;

        private InitShim() {
        }

        WindowScale revWindowScale() {
            if (this.revWindowScaleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revWindowScaleBuildStage == 0) {
                this.revWindowScaleBuildStage = (byte)-1;
                this.revWindowScale = Objects.requireNonNull(ImmutableRollingGroupSpec.super.revWindowScale(), "revWindowScale");
                this.revWindowScaleBuildStage = 1;
            }
            return this.revWindowScale;
        }

        void revWindowScale(WindowScale revWindowScale) {
            this.revWindowScale = revWindowScale;
            this.revWindowScaleBuildStage = 1;
        }

        WindowScale fwdWindowScale() {
            if (this.fwdWindowScaleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fwdWindowScaleBuildStage == 0) {
                this.fwdWindowScaleBuildStage = (byte)-1;
                this.fwdWindowScale = Objects.requireNonNull(ImmutableRollingGroupSpec.super.fwdWindowScale(), "fwdWindowScale");
                this.fwdWindowScaleBuildStage = 1;
            }
            return this.fwdWindowScale;
        }

        void fwdWindowScale(WindowScale fwdWindowScale) {
            this.fwdWindowScale = fwdWindowScale;
            this.fwdWindowScaleBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.revWindowScaleBuildStage == -1) {
                attributes.add("revWindowScale");
            }
            if (this.fwdWindowScaleBuildStage == -1) {
                attributes.add("fwdWindowScale");
            }
            return "Cannot build RollingGroupSpec, attribute initializers form cycle " + attributes;
        }
    }
}

