/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.api.updateby.spec.RollingMinMaxSpec;
import io.deephaven.api.updateby.spec.WindowScale;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="RollingMinMaxSpec", generator="Immutables")
@Immutable
final class ImmutableRollingMinMaxSpec
extends RollingMinMaxSpec {
    private final WindowScale revWindowScale;
    private final WindowScale fwdWindowScale;
    private final boolean isMax;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRollingMinMaxSpec(Builder builder) {
        this.isMax = builder.isMax;
        if (builder.revWindowScaleIsSet()) {
            this.initShim.revWindowScale(builder.revWindowScale);
        }
        if (builder.fwdWindowScaleIsSet()) {
            this.initShim.fwdWindowScale(builder.fwdWindowScale);
        }
        this.revWindowScale = this.initShim.revWindowScale();
        this.fwdWindowScale = this.initShim.fwdWindowScale();
        this.initShim = null;
    }

    @Override
    public WindowScale revWindowScale() {
        InitShim shim = this.initShim;
        return shim != null ? shim.revWindowScale() : this.revWindowScale;
    }

    @Override
    public WindowScale fwdWindowScale() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fwdWindowScale() : this.fwdWindowScale;
    }

    @Override
    public boolean isMax() {
        return this.isMax;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRollingMinMaxSpec && this.equalTo(0, (ImmutableRollingMinMaxSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableRollingMinMaxSpec another) {
        return this.revWindowScale.equals(another.revWindowScale) && this.fwdWindowScale.equals(another.fwdWindowScale) && this.isMax == another.isMax;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.revWindowScale.hashCode();
        h += (h << 5) + this.fwdWindowScale.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isMax);
        return h;
    }

    public String toString() {
        return "RollingMinMaxSpec{revWindowScale=" + this.revWindowScale + ", fwdWindowScale=" + this.fwdWindowScale + ", isMax=" + this.isMax + "}";
    }

    private static ImmutableRollingMinMaxSpec validate(ImmutableRollingMinMaxSpec instance) {
        instance.checkWindowSizes();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RollingMinMaxSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IS_MAX = 1L;
        private static final long OPT_BIT_REV_WINDOW_SCALE = 1L;
        private static final long OPT_BIT_FWD_WINDOW_SCALE = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private WindowScale revWindowScale;
        @Nullable
        private WindowScale fwdWindowScale;
        private boolean isMax;

        private Builder() {
        }

        public final Builder revWindowScale(WindowScale revWindowScale) {
            Builder.checkNotIsSet(this.revWindowScaleIsSet(), "revWindowScale");
            this.revWindowScale = Objects.requireNonNull(revWindowScale, "revWindowScale");
            this.optBits |= 1L;
            return this;
        }

        public final Builder fwdWindowScale(WindowScale fwdWindowScale) {
            Builder.checkNotIsSet(this.fwdWindowScaleIsSet(), "fwdWindowScale");
            this.fwdWindowScale = Objects.requireNonNull(fwdWindowScale, "fwdWindowScale");
            this.optBits |= 2L;
            return this;
        }

        public final Builder isMax(boolean isMax) {
            Builder.checkNotIsSet(this.isMaxIsSet(), "isMax");
            this.isMax = isMax;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRollingMinMaxSpec build() {
            this.checkRequiredAttributes();
            return ImmutableRollingMinMaxSpec.validate(new ImmutableRollingMinMaxSpec(this));
        }

        private boolean revWindowScaleIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean fwdWindowScaleIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isMaxIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of RollingMinMaxSpec is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.isMaxIsSet()) {
                attributes.add("isMax");
            }
            return "Cannot build RollingMinMaxSpec, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="RollingMinMaxSpec", generator="Immutables")
    private final class InitShim {
        private byte revWindowScaleBuildStage = 0;
        private WindowScale revWindowScale;
        private byte fwdWindowScaleBuildStage = 0;
        private WindowScale fwdWindowScale;

        private InitShim() {
        }

        WindowScale revWindowScale() {
            if (this.revWindowScaleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revWindowScaleBuildStage == 0) {
                this.revWindowScaleBuildStage = (byte)-1;
                this.revWindowScale = Objects.requireNonNull(ImmutableRollingMinMaxSpec.super.revWindowScale(), "revWindowScale");
                this.revWindowScaleBuildStage = 1;
            }
            return this.revWindowScale;
        }

        void revWindowScale(WindowScale revWindowScale) {
            this.revWindowScale = revWindowScale;
            this.revWindowScaleBuildStage = 1;
        }

        WindowScale fwdWindowScale() {
            if (this.fwdWindowScaleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fwdWindowScaleBuildStage == 0) {
                this.fwdWindowScaleBuildStage = (byte)-1;
                this.fwdWindowScale = Objects.requireNonNull(ImmutableRollingMinMaxSpec.super.fwdWindowScale(), "fwdWindowScale");
                this.fwdWindowScaleBuildStage = 1;
            }
            return this.fwdWindowScale;
        }

        void fwdWindowScale(WindowScale fwdWindowScale) {
            this.fwdWindowScale = fwdWindowScale;
            this.fwdWindowScaleBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.revWindowScaleBuildStage == -1) {
                attributes.add("revWindowScale");
            }
            if (this.fwdWindowScaleBuildStage == -1) {
                attributes.add("fwdWindowScale");
            }
            return "Cannot build RollingMinMaxSpec, attribute initializers form cycle " + attributes;
        }
    }
}

