/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.spec.ImmutableRollingCountSpec;
import io.deephaven.api.updateby.spec.RollingOpSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class RollingCountSpec
extends RollingOpSpec {
    public static RollingCountSpec ofTicks(long revTicks) {
        return RollingCountSpec.of(WindowScale.ofTicks(revTicks));
    }

    public static RollingCountSpec ofTicks(long revTicks, long fwdTicks) {
        return RollingCountSpec.of(WindowScale.ofTicks(revTicks), WindowScale.ofTicks(fwdTicks));
    }

    public static RollingCountSpec ofTime(String timestampCol, Duration revDuration) {
        return RollingCountSpec.of(WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingCountSpec ofTime(String timestampCol, Duration revDuration, Duration fwdDuration) {
        return RollingCountSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingCountSpec ofTime(String timestampCol, long revDuration) {
        return RollingCountSpec.of(WindowScale.ofTime(timestampCol, revDuration));
    }

    public static RollingCountSpec ofTime(String timestampCol, long revDuration, long fwdDuration) {
        return RollingCountSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration));
    }

    public static RollingCountSpec of(WindowScale revWindowScale) {
        return ImmutableRollingCountSpec.builder().revWindowScale(revWindowScale).build();
    }

    public static RollingCountSpec of(WindowScale revWindowScale, WindowScale fwdWindowScale) {
        return ImmutableRollingCountSpec.builder().revWindowScale(revWindowScale).fwdWindowScale(fwdWindowScale).build();
    }

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return true;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

